package com.elitesland.tw.tw5.api.prd.org.service;

import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgDimensionPayload;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDimensionVO;

import java.util.List;

public interface PrdOrgDimensionService {

    /**
     * 维度新增
     *
     * @param payload 单据数据
     */
    PrdOrgDimensionVO insert(PrdOrgDimensionPayload payload);

    /**
     * 维度修改
     *
     * @param payload 单据数据
     */
    Long update(PrdOrgDimensionPayload payload);

    /**
     * 维度状态修改
     *
     * @param id 主键 status状态
     */
    Long updateStatus(Long id, Integer status);


    /**
     * 维度逻辑删除
     *
     * @param keys 主键
     * @return result
     */
    boolean deleteSoft(List<Long> keys);

    /**
     * 列表查询
     *
     * @return
     */
    List<PrdOrgDimensionVO> queryList();

    /**
     * 根据版本号查询
     *
     * @return
     */
    PrdOrgDimensionVO queryByVersionId(Long versionId);

}
