package com.elitesland.tw.tw5.api.prd.personplan.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;


/**
 * @author : WWW
 * @date : 2024-2-21
 * @desc : 人员规划明细
 */
@Data
@ApiModel(description = "人员规划明细")
public class PersonPlanDtlQuery extends TwQueryParam {


    /**
     * 人员规划id
     */
    @ApiModelProperty("人员规划id")
    private Long planId;

    /**
     * 复合能力级别ID
     */

    @ApiModelProperty("复合能力级别ID")
    private Long capasetLevelId;


    /**
     * 资源
     */
    @ApiModelProperty("资源")
    private Long resId;

    /**
     * 派发系数
     */

    @ApiModelProperty("派发系数")
    private BigDecimal distributeRate;
    /**
     * 汇总当量
     */

    @ApiModelProperty("汇总当量")
    private BigDecimal totalEqva;
    /**
     * 隐藏标志
     */

    @ApiModelProperty("隐藏标志")
    private Integer hiddenFlag;

    /**
     * 角色
     */
    @ApiModelProperty("角色")
    private String roleCode;

    /**
     * 投入精力
     */
    @ApiModelProperty("投入精力")
    private BigDecimal input;

    /**
     * 人天单价
     */
    @ApiModelProperty("人天单价")
    private BigDecimal price;

    /**
     * 人天合计
     */
    @ApiModelProperty("人天合计")
    private BigDecimal days;

    /**
     * 金额合计
     */
    @ApiModelProperty("金额合计")
    private BigDecimal amt;

    /**
     * 天数明细
     */
    @ApiModelProperty("天数明细")
    private String daysJson;

    /**
     * 角色
     */
    @ApiModelProperty("角色")
    private Long roleId;

    /**
     * 相关方
     */
    @ApiModelProperty("相关方")
    private Long relatePartiesId;

    /**
     * 资源
     */
    @ApiModelProperty("资源")
    private List<Long> resIdList;

    /**
     * 相关方
     */
    @ApiModelProperty("相关方")
    private List<Long> relatePartiesIdList;
}

