package com.elitesland.tw.tw5.api.prd.personplan.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.ProRelatedPartiesPayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.ProRelatedPartiesQuery;
import com.elitesland.tw.tw5.api.prd.personplan.vo.CheckoutProRelatedRemoveVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.ProRelatedPartiesVO;


import java.util.List;


/**
 * @author : WWW
 * @date : 2024-1-29
 * @desc : 项目相关方Service
 */
public interface ProRelatedPartiesService {

   /**
    * 新增项目相关方数据
    * @param proRelatedPartiesPayload
    * @return
    */
   ProRelatedPartiesVO save(ProRelatedPartiesPayload proRelatedPartiesPayload);

   /**
    * 根据主键更新
    * @param proRelatedPartiesPayload
    * @return
    */
   ProRelatedPartiesVO updateAll(ProRelatedPartiesPayload proRelatedPartiesPayload);

   /**
    * 根据主键获取详情
    * @param id
    * @return
    */
   ProRelatedPartiesVO get(Long id);

   ProRelatedPartiesVO getSimple(Long id);


   /**
    * 分页查询列表
    * @param proRelatedPartiesQuery
    * @return
    */
   PagingVO<ProRelatedPartiesVO> page(ProRelatedPartiesQuery proRelatedPartiesQuery);

   /**
    * 根据主键批量删除
    * @param ids
    * @return
    */
   Long del(List<Long> ids);
    /**
     * 校验是否可以直接移除项目相关方
     * @param ids
     * @return
     */
    CheckoutProRelatedRemoveVO checkoutRemoveRelated(List<Long> ids);

   /**
    * 获取列表查询
    * @param proRelatedPartiesQuery
    * @return
    */
   List<ProRelatedPartiesVO> getList(ProRelatedPartiesQuery proRelatedPartiesQuery);
   List<ProRelatedPartiesVO> getListSimple(ProRelatedPartiesQuery proRelatedPartiesQuery);

    /**
     * 按项目id和用户id获取简单列表
     *
     * @param reasonId    原因id
     * @param loginUserId 登录用户id
     * @return {@link}<{@link ProRelatedPartiesVO}>
     */
    ProRelatedPartiesVO getListSimpleByProjectIdAndUserId(Long reasonId, Long loginUserId);

    /**
    * 根据条件修改
    * @param proRelatedPartiesPayload
    * @return
    */
   Long update(ProRelatedPartiesPayload proRelatedPartiesPayload,Integer sourceType);

    /**
     * 从相关方导入
     * @param proRelatedPartiesQuery
     * @return
     */
    List<ProRelatedPartiesVO> iportForm(ProRelatedPartiesQuery proRelatedPartiesQuery);


    Long count(ProRelatedPartiesQuery proRelatedPartiesQuery);

    /**
     * 相关方的项目分页列表
     * @param query
     * @return
     */
    PagingVO<ProRelatedPartiesVO> relatePaging(ProRelatedPartiesQuery query);
}

