package com.elitesland.tw.tw5.api.prd.pms.budget.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.budget.payload.PmsWbsBudgetDetailsPayload;
import com.elitesland.tw.tw5.api.prd.pms.budget.query.PmsWbsBudgetDetailsQuery;
import com.elitesland.tw.tw5.api.prd.pms.budget.vo.PmsWbsBudgetDetailsVO;
import com.elitesland.tw.tw5.api.prd.pms.budget.vo.PmsWbsBudgetVO;


import java.util.List;


/**
 * 预算明细表service
 * @author duwh
 * @date 2024/3/7
*/
public interface PmsWbsBudgetDetailsService {

    /**
     * 分页查询
     *
     * @param query query
     * @return result
     */
    PagingVO<PmsWbsBudgetDetailsVO> queryPage(PmsWbsBudgetDetailsQuery query);

    /**
     * 列表查询
     *
     * @param query query
     * @return result
     */
    List<PmsWbsBudgetDetailsVO> queryList(PmsWbsBudgetDetailsQuery query);

    /**
     * count查询
     *
     * @param query query
     * @return result
     */
    long queryCount(PmsWbsBudgetDetailsQuery query);

    /**
     * 根据主键获取详情
     *
     * @param id 主键
     * @return result
     */
    PmsWbsBudgetDetailsVO queryByKey(Long id);

    /**
     * 新增
     *
     * @param payload payload
     * @return result
     */
    PmsWbsBudgetDetailsVO insert(PmsWbsBudgetDetailsPayload payload);

    /**
     * 修改
     *
     * @param payload payload
     * @return result
     */
    PmsWbsBudgetDetailsVO update(PmsWbsBudgetDetailsPayload payload);

    /**
     * 动态修改，一般只用在少部分字段修改的场景，比如修改状态
     *
     * @param payload payload
     * @return result
     */
    PmsWbsBudgetDetailsVO updateDynamic(PmsWbsBudgetDetailsPayload payload);

    /**
     * 逻辑删除
     *
     * @param ids ids
     * @return result
     */
    Long deleteSoft(List<Long> ids);

    /**
     * 初始化
     *
     * @param payload 有效载荷
     */
    PmsWbsBudgetVO init(PmsWbsBudgetDetailsPayload payload);

    /**
     * 全部插入
     *
     * @param budgetDetailsPayloadList 预算详细信息有效载荷列表
     * @return {@link List}<{@link PmsWbsBudgetDetailsVO}>
     */
    List<PmsWbsBudgetDetailsVO> insertAll(List<PmsWbsBudgetDetailsPayload> budgetDetailsPayloadList);

    /**
     * 提交
     *
     * @param list 列表
     * @return {@link List}<{@link PmsWbsBudgetDetailsVO}>
     */
    List<PmsWbsBudgetDetailsVO> submit(List<PmsWbsBudgetDetailsPayload> list);

    void calculateMainTableInformation(Long budgetId);

    /**
     * 预算释放生效ok
     *
     * @param releaseIdList 发布id列表
     * @return {@link List}<{@link PmsWbsBudgetDetailsVO}>
     */
    List<PmsWbsBudgetDetailsVO> releaseOk(List<Long> releaseIdList);

    PmsWbsBudgetDetailsVO getByWbsId(Long wbsId,Long projectId);

    void updateList(List<PmsWbsBudgetDetailsPayload> payload);
}
