package com.elitesland.tw.tw5.api.prd.pms.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * wbs活动交付物
 *
 * @author carl
 * @date 2023-04-06
 */
@Getter
@Setter
public class PmsWbsActPayQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    @Query
    private Long id;
    /**
     * 项目主键 精确
     */
    @ApiModelProperty("项目主键")
    @Query
    private Long projectId;
    /**
     * wbs主键(仅活动类型) 精确
     */
    @ApiModelProperty("wbs主键(仅活动类型)")
    @Query
    private Long wbsId;
    /**
     * wbs描述（名称） 模糊
     */
    @ApiModelProperty("wbs描述（名称）")
    @Query(type = Query.Type.INNER_LIKE)
    private String wbsName;
    /**
     * 交付物名称 模糊
     */
    @ApiModelProperty("交付物名称")
    @Query(type = Query.Type.INNER_LIKE)
    private String payName;
    /**
     * 交付物类型 精确
     */
    @ApiModelProperty("交付物类型")
    @Query
    private String payType;
}
