package com.elitesland.tw.tw5.api.prd.pms.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsAcceptPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsAcceptQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsAcceptVO;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;


/**
 * @author : WWW
 * @date : 2024-2-26
 * @desc : 项目wbs验收标准Service
 */
public interface PmsProjectWbsAcceptService {

   /**
    * 新增项目wbs验收标准数据
    * @param pmsProjectWbsAcceptPayload
    * @return
    */
   PmsProjectWbsAcceptVO save(PmsProjectWbsAcceptPayload pmsProjectWbsAcceptPayload);

   /**
    * 根据主键更新
    * @param pmsProjectWbsAcceptPayload
    * @return
    */
   PmsProjectWbsAcceptVO updateAll(PmsProjectWbsAcceptPayload pmsProjectWbsAcceptPayload);

   /**
    * 根据主键获取详情
    * @param id
    * @return
    */
   PmsProjectWbsAcceptVO get(Long id);

   /**
    * 分页查询列表
    * @param pmsProjectWbsAcceptQuery
    * @return
    */
   PagingVO<PmsProjectWbsAcceptVO> page(PmsProjectWbsAcceptQuery pmsProjectWbsAcceptQuery);

   /**
    * 根据主键批量删除
    * @param ids
    * @return
    */
   Long del(List<Long> ids);

   /**
    * 获取列表查询
    * @param pmsProjectWbsAcceptQuery
    * @return
    */
   List<PmsProjectWbsAcceptVO> getList(PmsProjectWbsAcceptQuery pmsProjectWbsAcceptQuery);

    List<PmsProjectWbsAcceptVO> listByContentAndTypeEqualZero(List<String> contents);

    /**
    * 根据条件修改
    * @param pmsProjectWbsAcceptPayload
    * @return
    */
   Long update(PmsProjectWbsAcceptPayload pmsProjectWbsAcceptPayload);

    /**
     * 批量新增
     * @param pmsProjectWbsAcceptPayloadList
     * @return
     */
    Boolean saveAll(List<PmsProjectWbsAcceptPayload> pmsProjectWbsAcceptPayloadList);


    @Transactional(rollbackFor = Exception.class)
    Boolean updateWbsStatus(Long wbsId);
}

