package com.elitesland.tw.tw5.api.prd.pms.vo;

import cn.zhxu.bs.bean.DbField;
import cn.zhxu.bs.bean.DbIgnore;
import cn.zhxu.bs.bean.SearchBean;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseContractManagerVO;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;


/**
 * 项目
 *
 * @author carl
 * @date 2023-08-07
 */
@SearchBean(
        tables = "pms_project pp " +
                "left join sale_con_contract scc on pp.contract_id = scc.id ",
        where = "pp.delete_flag = 0 and scc.delete_flag = 0 ",
        groupBy = ":groupBy:",
        autoMapTo = "pp"
)
@Getter
@Setter
public class PmsProjectVO extends BaseViewModel implements Serializable {
    /**
     * 记录唯一ID
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 记录创建者ID
     */
    @ApiModelProperty("记录创建者ID")
    private Long createUserId;
    /**
     * 记录创建时间
     */
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;
    /**
     * 记录最后更新者ID
     */
    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId = 0L;
    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;
    /**
     * 项目重要度
     */
    @ApiModelProperty("项目重要度")
    private String projectImportance;

    @DbIgnore
    @UdcName(udcName = "ACC:PROJECT_IMPORTANCE", codePropName = "projectImportance")
    private String projectImportanceDesc;
    /**
     * 预算总人天
     */
    @ApiModelProperty("预算总人天")
    private BigDecimal totalDays;
    /**
     * 费用总成本
     */
    @ApiModelProperty("费用总成本")
    private BigDecimal totalCost;
    /**
     * 工时结算周期
     */
    @ApiModelProperty("工时结算周期")
    private String timesheetPeriod;
    @DbIgnore
    @UdcName(udcName = "TSK:TIMESHEET_SETTLE_PERIOD", codePropName = "timesheetPeriod")
    private String timesheetPeriodDesc;
    /**
     * 项目名称
     */
    @ApiModelProperty("项目名称")
    private String projName;
    /**
     * 项目状态
     */
    @ApiModelProperty("项目状态")
    private String projStatus;

    @DbIgnore
    @UdcName(udcName = "TSK:PROJ_STATUS", codePropName = "projStatus")
    private String projStatusDesc;
    /**
     * 合同id
     */
    @ApiModelProperty("合同id")
    private Long contractId;
    /**
     * 客户id
     */
    @ApiModelProperty("客户id")
    @DbField(mapTo = "scc")
    private Long custId;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    @DbIgnore
    private String custName;

    /**
     * 项目模板id
     */
    @ApiModelProperty("项目模板id")
    private Long projTempId;
    /**
     * 客户行业
     */
    @ApiModelProperty("客户行业")
    private String custIdst;

    @DbIgnore
    @UdcName(udcName = "crm:leads_customer_industry", codePropName = "custIdst")
    private String custIdstDesc;
    /**
     * 客户区域
     */
    @ApiModelProperty("客户区域")
    private String custRegion;

    @DbIgnore
    @UdcName(udcName = "crm:customer_region", codePropName = "custRegion")
    private String custRegionDesc;
    /**
     * 预计开始日期
     */
    @ApiModelProperty("预计开始日期")
    private LocalDate planStartDate;
    /**
     * 预计结束日期
     */
    @ApiModelProperty("预计结束日期")
    private LocalDate planEndDate;
    /**
     * 实际开始日期
     */
    @ApiModelProperty("实际开始日期")
    private LocalDate startDate;
    /**
     * 实际结束日期
     */
    @ApiModelProperty("实际结束日期")
    private LocalDate endDate;

    /**
     * 项目经理资源id
     */
    @ApiModelProperty("项目经理资源id")
    private Long pmResId;

    @DbIgnore
    @UdcName(udcName = "USER", codePropName = "pmResId")
    private String pmResName;
    /**
     * 项目经理当量系数
     */
    @ApiModelProperty("项目经理当量系数")
    private BigDecimal pmEqvaRatio;
    /**
     * pmo资源负责人id
     */
    @ApiModelProperty("pmo资源负责人id")
    private Long pmoResId;

    @DbIgnore
    @UdcName(udcName = "USER", codePropName = "pmoResId")
    private String pmoResName;

    /**
     * 督导资源id
     */
    @ApiModelProperty("督导资源id")
    private Long superResId;

    @DbIgnore
    @UdcName(udcName = "USER", codePropName = "superResId")
    private String superResName;

    /**
     * 项目风险等级
     */
    @ApiModelProperty("项目风险等级")
    private String riskLevel;

    @DbIgnore
    @UdcName(udcName = "PMS:PROJECT:RISK", codePropName = "riskLevel")
    private String riskLevelDesc;

    /**
     * pmo助理资源负责人id
     */
    @ApiModelProperty("pmo助理资源负责人id")
    private Long pmoDeputyResId;

    @DbIgnore
    @UdcName(udcName = "USER", codePropName = "pmoDeputyResId")
    private String pmoDeputyResName;
    /**
     * 总当量
     */
    @ApiModelProperty("总当量")
    private BigDecimal totalEqva;
    /**
     * 派发当量（交付负责人-项目经理）
     */
    @ApiModelProperty("派发当量（交付负责人-项目经理）")
    private BigDecimal distEqva;
    /**
     * 派发费用（交付负责人-项目经理）
     */
    @ApiModelProperty("派发费用（交付负责人-项目经理）")
    private BigDecimal distCost;
    /**
     * 费用总预算
     */
    @ApiModelProperty("费用总预算")
    private BigDecimal totalReimbursement;
    /**
     * 当量预估单价
     */
    @ApiModelProperty("当量预估单价")
    private BigDecimal eqvaPrice;

    /**
     * 允许外包
     */
    @ApiModelProperty("允许外包")
    private Integer epibolyPermitFlag;
    /**
     * 允许转包
     */
    @ApiModelProperty("允许转包")
    private Integer subcontractPermitFlag;
    /**
     * 非结算活动需要审批
     */
    @ApiModelProperty("非结算活动需要审批")
    private Integer finishApproveFlag;
    /**
     * 最低保证金
     */
    @ApiModelProperty("最低保证金")
    private BigDecimal deposit;
    /**
     * 关联项目
     */
    @ApiModelProperty("关联项目")
    private Long relatedProjId;
    /**
     * 绩效规则
     */
    @ApiModelProperty("绩效规则")
    private String performanceDesc;
    /**
     * 关闭原因
     */
    @ApiModelProperty("关闭原因")
    private String closeReason;

    /**
     * 差旅餐补限额
     */
    @ApiModelProperty("差旅餐补限额")
    private BigDecimal maxTravelFee;
    /**
     * 项目编号
     */
    @ApiModelProperty("项目编号")
    private String projNo;
    /**
     * 完工百分比
     */
    @ApiModelProperty("完工百分比")
    private BigDecimal compPercent;
    /**
     * 允许一人多任务包
     */
    @ApiModelProperty("允许一人多任务包")
    private Integer muiltiTaskFlag;
    /**
     * 项目进度状态
     */
    @ApiModelProperty("项目进度状态")
    private String projProcessStatus;

    @DbIgnore
    @UdcName(udcName = "PMS:PROCESS:STATUS", codePropName = "projProcessStatus")
    private String projProcessStatusDesc;
    /**
     * 最新汇报时间时间
     */
    @ApiModelProperty("最新汇报时间时间")
    private LocalDateTime reportTime;
    /**
     * 自动汇报标识
     */
    @ApiModelProperty("自动汇报标识")
    private Integer autoReportFlag;
    /**
     * 每期确认金额
     */
    @ApiModelProperty("每期确认金额")
    private BigDecimal reportPeriodAmt;
    /**
     * 汇报开始期间
     */
    @ApiModelProperty("汇报开始期间")
    private LocalDate reportStartDate;
    /**
     * 汇报期间数
     */
    @ApiModelProperty("汇报期间数")
    private Integer reportQty;
    /**
     * 包含客户承担费用标志
     */
    @ApiModelProperty("包含客户承担费用标志")
    private Integer containsCustomerFlag;
    /**
     * 项目难度
     */
    @ApiModelProperty("项目难度")
    private String projectDifficult;

    @DbIgnore
    @UdcName(udcName = "ACC:PROJECT_DIFFICULTY", codePropName = "projectDifficult")
    private String projectDifficultDesc;
    /**
     * 项目预算总开关标志 0:否 1:是
     */
    @ApiModelProperty("项目预算总开关标志 0:否 1:是")
    private Integer budgetSwitchFlag;
    /**
     * 项目活动状态
     */
    @ApiModelProperty("项目活动状态 ")
    private String projActivityStatus;
    /**
     * 项目活动审批状态
     */
    @ApiModelProperty("项目活动审批状态 ")
    private String projActivityApprStatus;
    /**
     * 关联项目编号
     */
    @ApiModelProperty("关联项目编号")
    private String relatedProjNo;
    /**
     * 产品编号
     */
    @ApiModelProperty("产品编号")
    private String productNo;
    /**
     * 易道壳项目过程文档itemid
     */
    @ApiModelProperty("易道壳项目过程文档itemid")
    private String processDocItemId;
    /**
     * 易道壳项目验收文档itemid
     */
    @ApiModelProperty("易道壳项目验收文档itemid")
    private String acceptanceDocItemId;
    /**
     * 易道壳项目总结文档itemid
     */
    @ApiModelProperty("易道壳项目总结文档itemid")
    private String summaryDocItemId;
    /**
     * 研发补贴金额
     */
    @ApiModelProperty("研发补贴金额")
    private BigDecimal subsidyAmt;
    /**
     * 直接改为周末现场有补助（原字段：折旧月数）
     */
    @ApiModelProperty("直接改为周末现场有补助")
    private Integer depreciationMonths;
    /**
     * 折旧开始时间
     */
    @ApiModelProperty("折旧开始时间")
    private LocalDateTime depreciationStartDate;
    /**
     * sow节选
     */
    @ApiModelProperty("sow节选")
    private String sowFiles;
    /**
     * sow节选附件
     */
    @ApiModelProperty("sow节选附件")
    @DbIgnore
    private Object sowFilesData;
    /**
     * 预算附件
     */
    @ApiModelProperty("预算附件")
    private String budgetFiles;
    /**
     * 预算附件
     */
    @ApiModelProperty("预算附件")
    @DbIgnore
    private Object budgetFilesData;
    /**
     * 绩效附件
     */
    @ApiModelProperty("绩效附件")
    private String performanceFiles;
    /**
     * 绩效附件
     */
    @ApiModelProperty("绩效附件")
    @DbIgnore
    private Object performanceFilesData;
    /**
     * 附件
     */
    @ApiModelProperty("附件")
    private String projectFiles;
    /**
     * 附件
     */
    @ApiModelProperty("附件")
    @DbIgnore
    private Object projectFilesData;
    /**
     * 项目类型
     */
    @ApiModelProperty("项目类型")
    private String ext1;

    @DbIgnore
    @UdcName(udcName = "PMS:PROJECT:OTHER", codePropName = "ext1")
    private String ext1Desc;


    /**
     * 项目收入确认备注
     */
    @ApiModelProperty("项目收入确认备注")
    private String ext2;
    /**
     * 扩展字段3
     */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /**
     * 扩展字段4
     */
    @ApiModelProperty("扩展字段4")
    private String ext4;
    /**
     * 扩展字段5
     */
    @ApiModelProperty("扩展字段5")
    private String ext5;
    /**
     * 帮我吧项目名称
     */
    @ApiModelProperty("帮我吧项目名称")
    @DbField("pp.bangwo8proj_name")
    private String bangwo8ProjName;

    /**
     * 研发立项附件
     */
    @ApiModelProperty("研发立项附件")
    private String researchFiles;
    @ApiModelProperty("研发立项附件")
    @DbIgnore
    private Object researchFilesData;


    /**
     * 子合同编号
     */
    @ApiModelProperty("子合同编号")
    @DbField("scc.code")
    private String contractNo;
    /**
     * 子合同名称
     */
    @ApiModelProperty("子合同名称")
    @DbField("scc.name")
    private String contractName;
    /**
     * 参考合同号
     */
    @ApiModelProperty("参考合同号")
    @DbField(mapTo = "scc")
    private String referCode;
    /**
     * 平台提成百分比
     */
    @ApiModelProperty("平台提成百分比")
    @DbField(mapTo = "scc")
    private BigDecimal percentage;


    /**
     * 交付BU_ID
     */
    @DbField(mapTo = "scc")
    @ApiModelProperty("交付BU_ID")
    private Long deliBuId;
    /**
     * 交付BU名称
     */
    @UdcName(udcName = "BU", codePropName = "deliBuId")
    @DbIgnore
    private String deliBuName;
    /**
     * 工作类型
     */
    @ApiModelProperty("工作类型")
    @DbField(mapTo = "scc")
    private String workType;

    @DbIgnore
    @UdcName(udcName = "salecon:work_type", codePropName = "workType")
    private String workTypeDesc;
    /**
     * 平台合同类型
     */
    @ApiModelProperty("平台合同类型")
    @DbField(mapTo = "scc")
    private String platType;

    @DbIgnore
    @UdcName(udcName = "salecon:plat_type", codePropName = "platType")
    private String platTypeDesc;
    /**
     * 合同总金额
     */
    @ApiModelProperty("合同总金额")
    @DbField("scc.amt")
    private BigDecimal sumAmt;

    /**
     * 合同状态
     */
    @ApiModelProperty("合同状态")
    @DbField("scc.status")
    private String contractStatus;
    /**
     * 销售负责人ID
     */
    @ApiModelProperty("销售负责人ID")
    @DbField(mapTo = "scc")
    private Long saleManUserId;
    /**
     * 销售负责人名称
     */
    @UdcName(udcName = "USER", codePropName = "saleManUserId")
    @DbIgnore
    private String saleManUserName;
    /**
     * 币种
     */
    @ApiModelProperty("币种")
    @DbField(mapTo = "scc")
    private String currCode;

    @DbIgnore
    @UdcName(udcName = "SYSTEM_BASIC:CURRENCY", codePropName = "currCode")
    private String currCodeDesc;
    /**
     * 客户承担差旅费
     */
    @ApiModelProperty("客户承担差旅费")
    @DbField(mapTo = "scc")
    private String custBarExpense;

    @DbIgnore
    @UdcName(udcName = "salecon:cust_bear", codePropName = "custBarExpense")
    private String custBarExpenseDesc;
//    /**
//     * 签约公司ID
//     */
//    @ApiModelProperty("签约公司ID")
//    @DbField(mapTo = "scc")
//    private Long ouId;
    /**
     * 签约公司ID
     */
    @ApiModelProperty("签约公司ID")
    @DbField(mapTo = "scc")
    private Long ouBookId;

    @DbIgnore
    @UdcName(udcName = "BOOK", codePropName = "ouBookId")
    private String ouName;
    /**
     * 交付地点
     */
    @ApiModelProperty("交付地点")
    @DbField(mapTo = "scc")
    private String deliveryAddress;
    /**
     * 交付用户id
     */
    @ApiModelProperty("交付用户id")
    @DbField(mapTo = "scc")
    private Long deliUserId;
    /**
     * 交付用户名称
     */
    @DbIgnore
    @UdcName(udcName = "USER", codePropName = "deliUserId")
    private String deliUserName;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    @DbField(mapTo = "scc")
    private BigDecimal taxRate;
    @DbIgnore
    @UdcName(udcName = "SYSTEM_BASIC:TAX", codePropName = "taxRate")
    private String taxRateDesc;


    /**
     * 变更中标志 0:否 1:是
     */
    @ApiModelProperty("变更中标志 0:否 1:是")
    private Integer changeFlag = 0;

    /**
     * 预计上线日期
     */
    @ApiModelProperty("预计上线日期")
    private LocalDate planOnlineDate;
    /**
     * 财务核定额定当量
     */
    @ApiModelProperty("财务核定额定当量")
    @DbField(mapTo = "scc")
    private BigDecimal finRatedEqva;
    /**
     * 额定费用
     */
    @ApiModelProperty("额定费用")
    @DbField(mapTo = "scc")
    private BigDecimal ratedCost;

    /**
     * 项目汇报计划
     */
    @ApiModelProperty("项目汇报计划")
    @DbIgnore
    private List<PmsProjectReportPlanVO> projectReportPlanVOs;

    /**
     * 变更删除的项目汇报计划ids
     */
    @ApiModelProperty("变更删除的项目汇报计划ids")
    @DbIgnore
    private List<Long> delReportPlanIds;
    /**
     * 签单buid
     */
    @ApiModelProperty("签单buid")
    @DbField(mapTo = "scc")
    private Long signBuId;

    /**
     * 科目模板id
     */
    @ApiModelProperty("科目模板id")
    private Long subjectTempId;
    /**
     * 0:不需要提示 1:需要无合同项目激活后代办提示，2:需要预算变更代办提示
     */
    @ApiModelProperty("无合同项目激活后代办提示")
    private Integer noContractFlag;
    /**
     * 有效合同金额
     */
    @ApiModelProperty("有效合同金额")
    @DbField(mapTo = "scc")
    private BigDecimal effectiveAmt;


    /**
     * 预算总额
     */
    @ApiModelProperty("预算总额")
    @DbIgnore
    private BigDecimal feeBudgetAmt;

    /**
     * 当量预算总数
     */
    @ApiModelProperty("当量预算总数")
    @DbIgnore
    private BigDecimal eqvaBudgetCnt;
    /**
     * 已拨付当量数
     */
    @ApiModelProperty("已拨付当量数")
    @DbIgnore
    private BigDecimal eqvaReleasedQty;
    /**
     * 剩余拨付当量
     */
    @ApiModelProperty("剩余拨付当量")
    @DbIgnore
    private BigDecimal remainReleasedEqva;

    /**
     * 项目剩余当量
     */
    @ApiModelProperty("项目剩余当量")
    @DbIgnore
    private BigDecimal remainEqva;
    /**
     * 已结算当量
     */
    @ApiModelProperty("已结算当量")
    @DbIgnore
    private BigDecimal settledEqva;
    /**
     * 已收款金额
     */
    @ApiModelProperty("已收款金额")
    @DbIgnore
    private BigDecimal recvedAmt;
    /**
     * 未收款金额
     */
    @ApiModelProperty("未收款金额")
    @DbIgnore
    private BigDecimal notReceivedAmt;
    /**
     * 已开票金额
     */
    @ApiModelProperty("已开票金额")
    @DbIgnore
    private BigDecimal invoicedAmt;

    /**
     * 商机ID
     */
    @ApiModelProperty("商机ID")
    @DbField(mapTo = "scc")
    private Long oppoId;

    /**
     * 资源规划更新日期
     */
    @ApiModelProperty("资源规划更新日期")
    private LocalDateTime planUpdateDate;

    // 销售合同侧 字段 --------start
    /**
     * 产品大类
     */
    @ApiModelProperty("产品大类")
    @DbField(mapTo = "scc")
    private String productClass;

    @UdcName(udcName = "con:sales_class", codePropName = "productClass")
    @DbIgnore
    private String productClassDesc;
    /**
     * 产品小类
     */
    @ApiModelProperty("产品小类")
    @DbField(mapTo = "scc")
    private String productSubClass;
    // private String productSubClassDesc;

    /**
     * 签订日期
     */
    @ApiModelProperty("签订日期")
    @DbField("scc.sign_date")
    private LocalDate contractSignDate;

    /**
     * 合同开始日期
     */
    @ApiModelProperty("合同开始日期")
    @DbField("scc.start_date")
    private LocalDate contractStartDate;

    /**
     * 合同结束日期
     */
    @ApiModelProperty("合同结束日期")
    @DbField("scc.end_date")
    private LocalDate contractEndDate;

    /**
     * 项目执行当量(EEQ)
     */
    @ApiModelProperty("项目执行当量(EEQ)")
    @DbIgnore
    private BigDecimal projExecEquiv;
    // 销售合同侧 字段 --------end

    /**
     * 是否有活动
     */
    @ApiModelProperty("是否有活动")
    @DbIgnore
    private Integer haveActivityFlag;

    /**
     * 是否有成员
     */
    @ApiModelProperty("是否有成员")
    @DbIgnore
    private Integer haveMemberFlag;

    /**
     * 是否有资源规划
     */
    @ApiModelProperty("是否有资源规划")
    @DbIgnore
    private Integer haveResoucePlanFlag;

    /**
     * 是否有预算
     */
    @ApiModelProperty("是否有预算")
    @DbIgnore
    private Integer haveBudgetFlag;

    /**
     * 是否有任务
     */
    @ApiModelProperty("是否有任务")
    @DbIgnore
    private Integer haveTaskFlag;
    /**
     * 成本级别
     */
    @ApiModelProperty("成本级别")
    private String costLevel;
    @DbIgnore
    @UdcName(udcName = "PMS:PROJECT:COST_LEVEL", codePropName = "costLevel")
    private String costLevelDesc;

    /**
     * 费用承担bu
     */
    @ApiModelProperty("费用承担bu")
    private Long expenseBuId;

    /////////////////////////////////////////////////


    /**
     * JDE凭证号
     */
    @ApiModelProperty("JDE凭证号")
    @DbIgnore
    private String jdeDocNo;

    /**
     * JDE凭证状态
     */
    @ApiModelProperty("JDE凭证状态")
    @DbIgnore
    private String jdeDocState;

    /**
     * JDE凭证状态
     */
    @ApiModelProperty("JDE凭证状态")
    @DbIgnore
    @UdcName(udcName = "JDE:JDE_STATUS", codePropName = "jdeDocState")
    private String jdeDocStateDesc;

    /**
     * JDE凭证失败原因
     */
    @ApiModelProperty("JDE凭证失败原因")
    @DbIgnore
    private String jdeErrMsg;

    /**
     * 主要有未确认、部分确认、全部确认等；
     * <p>
     * JDE收入确认金额不含税 = 0为未确认；
     * （0<JDE收入确认金额（不含税）< 合同金额（不含税）为部分确认，JDE收入确认金额（不含税=合同金额（不含税）为全部确认
     */
    @ApiModelProperty("收入确认状态")
    @DbIgnore
    private String jdeConfirmState;

    /**
     * JDE收入确认金额（不含税），取明细汇总
     */
    @ApiModelProperty("JDE收入确认金额（不含税）,取明细汇总")
    @DbIgnore
    private BigDecimal jdeConfirmSumAmt;

    /**
     * 摘要
     */
    @ApiModelProperty("摘要")
    @DbIgnore
    private String jdeSummary;

    /**
     * 凭证日期  24/05/10
     */
    @ApiModelProperty("凭证日期")
    @DbIgnore
    private String jdeDocTime;


    /**
     * 未开票金额
     */
    @ApiModelProperty("未开票金额")
    @DbIgnore
    private BigDecimal notInvAmt;


    /**
     * 1、交付项目、自主研发 是根据按钮“收入确认”提交的时间
     * <p>
     * 2、其他项目 的收入确认时间 取结项申请日期  、创建人提交日期
     */
    @ApiModelProperty("收入确认日期")
    @DbIgnore
    private LocalDateTime jdeConfirmTime;

    /**
     * 项目结项创建时间
     */
    @ApiModelProperty("项目结项创建时间")
    @DbIgnore
    private LocalDateTime conclusionCreateTime;

    /**
     * 采购合同
     */
    @ApiModelProperty("采购合同")
    @DbIgnore
    private List<PurchaseContractManagerVO> purchaseContractManagerVOList;

    /**
     * 账户状态
     */
    @ApiModelProperty("账户状态")
    @DbIgnore
    private String accountStatus;

    @ApiModelProperty("预算模板-预算控制 是否开启 1开启 0关闭")
    @DbIgnore
    private Integer budgetControlFlag;

    @ApiModelProperty("预算控制策略 0不控制")
    @DbIgnore
    private String budgetControlStrategyFlag;

    @ApiModelProperty("节点进度更新时间")
    @DbIgnore
    private LocalDate wbsProgressUpdateTime;
}
