package com.elitesland.tw.tw5.api.prd.purchase.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PaymentPlanReferPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.PaymentPlanReferQuery;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PaymentPlanReferVO;

import java.util.List;

/**
 * 付款计划参考
 *
 * @author likunpeng
 * @date 2023-11-22
 */
public interface PaymentPlanReferService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PaymentPlanReferVO}>
     */
    PagingVO<PaymentPlanReferVO> queryPaging(PaymentPlanReferQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PaymentPlanReferVO}>
     */
    List<PaymentPlanReferVO> queryListDynamic(PaymentPlanReferQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PaymentPlanReferVO}
     */
    PaymentPlanReferVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PaymentPlanReferVO}
     */
    PaymentPlanReferVO insert(PaymentPlanReferPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PaymentPlanReferVO}
     */
    PaymentPlanReferVO update(PaymentPlanReferPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(PaymentPlanReferPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 批量新增付款计划参考
     * @param paymentPlanReferPayloads 要新增的付款计划参考
     */
    void saveAll(List<PaymentPlanReferPayload> paymentPlanReferPayloads);

    /**
     * 根据付款申请单ID删除付款计划参考
     * @param id 付款申请单Id
     */
    void deleteByPaymentId(Long id);

    /**
     * 根据付款申请单ID查询列表
     *
     * @param paymentApplyId 付款申请单ID
     * @return {@link List}<{@link PaymentPlanReferVO}>
     */
    List<PaymentPlanReferVO> queryListByPaymentApplyId(Long paymentApplyId);
}
