package com.elitesland.tw.tw5.api.prd.purchase.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PaymentAccountantApprovePayload;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PaymentSlipPayload;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchasePaymentPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchasePaymentDefaultQuery;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchasePaymentQuery;
import com.elitesland.tw.tw5.api.prd.purchase.vo.CostUndertakeDepartmentVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurConOrAgreementDetailsSimpleVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchasePaymentVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.WriteOffPaymentApplyVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;

import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 付款申请单
 *
 * @author likunpeng
 * @date 2023-11-07
 */
public interface PurchasePaymentService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PurchasePaymentVO}>
     */
    PagingVO<PurchasePaymentVO> queryPaging(PurchasePaymentQuery query);


    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PurchasePaymentVO}
     */
    PurchasePaymentVO queryByKey(Long key);

    /**
     * 通过主键查询主题信息
     *
     * @param key 主键
     * @return {@link PurchasePaymentVO}
     */
    PurchasePaymentVO queryMainInfoByKey(Long key);
    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PurchasePaymentVO}
     */
    PurchasePaymentVO insertOrUpdate(PurchasePaymentPayload payload);

    /**
     * 付款申请单-应付会计审批
     *
     * @param payload 应付会计审批
     * @return {@link PurchasePaymentVO}
     */
    PurchasePaymentVO accountantApprove(PaymentAccountantApprovePayload payload);

    /**
     * 逻辑删除
     *
     * @param id        主键
     * @param isInvalid 是否是作废
     */
    void deleteSoft(Long id, Boolean isInvalid);

    /**
     * 查询日志列表
     *
     * @param key key
     * @return {@link List}<{@link PrdSystemLogVO}>
     */
    List<PrdSystemLogVO> queryLogList(Long key);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return 条数
     */
    long updateByKeyDynamic(PurchasePaymentPayload payload);

    /**
     * 根据申请单类型以及单据编号查询默认信息
     *
     * @param defaultQuery 查询条件
     */
    PurchasePaymentVO getDefaultByTypeAndDocNo(PurchasePaymentDefaultQuery defaultQuery);

    /**
     * 获取流程节点处理人
     *
     * @param purchasePaymentVO 付款申请单VO
     * @return 流程节点处理人
     */
    HashMap<String, Object> getVariables(PurchasePaymentVO purchasePaymentVO);

    /**
     * 导出付款单列表excel
     *
     * @param query 查询条件
     * @return result
     */
    void exportPaymentApply(HttpServletResponse response, PurchasePaymentQuery query);

    /**
     * 权限导出付款单列表excel
     *
     * @param query 查询条件
     * @return result
     */
    void permissionExportPaymentApply(HttpServletResponse response, PurchasePaymentQuery query);

    /**
     * 根据流程编号查询该流程是否符合紧急付款条件
     *
     * @param procInstId 流程实例id
     */
    PurchasePaymentVO findUrgentPaymentByProcInstId(String procInstId);

    /**
     * 根据docNo和状态查询付款申请单
     *
     * @param docNo
     */
    List<PurchasePaymentVO> queryByDocNo(String docNo, List<String> statusLis);

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    List<PurchasePaymentVO> queryListDynamic(PurchasePaymentQuery query);

    /**
     * 分页列表-权限分页
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PurchasePaymentVO}>
     */
    PagingVO<PurchasePaymentVO> permissionPaging(PurchasePaymentQuery query);

    /**
     * 根据预付款申请单编号查询预付款核销申请单
     *
     * @param prePaymentApplyNoList 预付款申请单号list
     * @return 预付款核销单Map
     */
    Map<String, List<WriteOffPaymentApplyVO>> findWriteOffByPrePaymentNoList(List<String> prePaymentApplyNoList);

    /**
     * 根据采购合同IdOr采购协议Id查询采购明细
     *
     * @param purConOrAgreementId 采购合同Id
     * @param docType             关联单据类型
     * @return 采购明细
     */
    List<PurConOrAgreementDetailsSimpleVO> queryByPurConOrAgreementId(Long purConOrAgreementId, String docType);

    /**
     * 根据发票号查询已经传输JDE的费用部门承担明细
     *
     * @param invoiceNo 发票号
     * @return 费用承担明细
     */
    List<CostUndertakeDepartmentVO> queryByPurConOrInvoiceNo(String invoiceNo);

    /**
     * 根据发票号批量查询已经传输JDE的费用部门承担明细
     *
     * @param payload 发票号
     * @return 费用承担明细
     */
    List<CostUndertakeDepartmentVO> queryByPurConOrInvoiceNos(PaymentSlipPayload payload);
}
