package com.elitesland.tw.tw5.api.prd.salecon.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * 采购需求处理明细
 *
 * @author likunpeng
 * @date 2023-03-29
 */
@Getter
@Setter
public class ConPurchaseDemandDQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    @Query
    private Long id;

    /**
     * 记录唯一ID集合 精确
     */
    @ApiModelProperty("记录唯一ID集合")
    @Query
    private List<Long> ids;
    /**
     * 建议供应商ID 精确
     */
    @ApiModelProperty("建议供应商ID")
    @Query
    private Long supplierId;
    /**
     * 需求说明 模糊
     */
    @ApiModelProperty("需求说明")
    @Query(type = Query.Type.INNER_LIKE)
    private String demandSaid;
    /**
     * 关联产品 精确
     */
    @ApiModelProperty("关联产品")
    @Query
    private Long productId;
    /**
     * 采购大类 精确
     */
    @ApiModelProperty("采购大类")
    @Query
    private String productClass;
    /**
     * 采购小类 精确
     */
    @ApiModelProperty("采购小类")
    @Query
    private String productSubClass;
    /**
     * 数量 精确
     */
    @ApiModelProperty("数量")
    @Query
    private Integer demandNum;
    /**
     * 含税单价 精确
     */
    @ApiModelProperty("含税单价")
    @Query
    private BigDecimal taxPrice;
    /**
     * 货币 精确
     */
    @ApiModelProperty("货币")
    @Query
    private String symbol;
    /**
     * 税率 精确
     */
    @ApiModelProperty("税率")
    @Query
    private BigDecimal taxRate;
    /**
     * 含税总额 精确
     */
    @ApiModelProperty("含税总额")
    @Query
    private BigDecimal taxAmt;
    /**
     * 不含税总额 精确
     */
    @ApiModelProperty("不含税总额")
    @Query
    private BigDecimal notTaxAmt;
    /**
     * 采购合同id 精确
     */
    @ApiModelProperty("采购合同id")
    @Query
    private Long purContractId;

    /**
     * 采购需求id 精确
     */
    @ApiModelProperty("采购需求id")
    @Query
    private Long purDemandId;
    /**
     * 需求编号 模糊
     */
    @ApiModelProperty("需求编号")
    @Query
    private String demandCode;
    /**
     * 销售合同ID 模糊
     */
    @ApiModelProperty("销售合同ID")
    @Query
    private Long saleConId;
    /**
     * 销售合同编号 模糊
     */
    @ApiModelProperty("销售合同编号")
    @Query
    private String saleConCode;
    /**
     * 需求负责人ID 精确
     */
    @ApiModelProperty("需求负责人ID")
    @Query
    private Long demandDirectorUserId;
    /**
     * 需求类别 精确
     */
    @ApiModelProperty("需求类别")
    @Query
    private String demandType;
    /**
     * 需求日期 范围
     */
    @ApiModelProperty("需求日期")
    @Query
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private List<LocalDate> demandDate;
    /**
     * 参考合同号 模糊
     */
    @ApiModelProperty("参考合同号")
    @Query
    private String referCode;
    /**
     * 客户ID 精确
     */
    @Query
    @ApiModelProperty("客户ID")
    private Long custId;
    /**
     * 需求状态
     */
    @ApiModelProperty("需求状态")
    @Query
    private String demandStatus;

    /**
     * 组织id集合，用于列表权限
     */
    private List<Long> orgIdsByPermission;

    /**
     * 用户id集合，用于列表权限
     */
    private List<Long> userIdsByPermission;
}
