package com.elitesland.tw.tw5.api.prd.salecon.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConPurchaseDemandPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConPurchaseDemandQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConPurchaseDemandVO;

import java.util.List;

/**
 * 采购需求处理
 *
 * @author likunpeng
 * @date 2023-03-29
 */
public interface ConPurchaseDemandService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link ConPurchaseDemandVO}>
     */
    PagingVO<ConPurchaseDemandVO> paging(ConPurchaseDemandQuery query);

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link ConPurchaseDemandVO}>
     */
    PagingVO<ConPurchaseDemandVO> queryPaging(ConPurchaseDemandQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link ConPurchaseDemandVO}>
     */
    List<ConPurchaseDemandVO> queryList(ConPurchaseDemandQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link ConPurchaseDemandVO}>
     */
    List<ConPurchaseDemandVO> queryListDynamic(ConPurchaseDemandQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link ConPurchaseDemandVO}
     */
    ConPurchaseDemandVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link ConPurchaseDemandVO}
     */
    ConPurchaseDemandVO insert(ConPurchaseDemandPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link ConPurchaseDemandVO}
     */
    ConPurchaseDemandVO update(ConPurchaseDemandPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 根据ID查询采购需求
     * @param saleConId
     * @return {@link ConPurchaseDemandVO}
     */
    ConPurchaseDemandVO queryBySaleConId(Long saleConId);
//
//    @Deprecated
//    void syncPurcDemandTo4(String param);
}
