package com.elitesland.tw.tw5.api.prd.ts.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConInvSettingPayload;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.api.prd.ts.payload.TsApprovalResPayload;
import com.elitesland.tw.tw5.api.prd.ts.payload.TsNotaskApprovalConfigPayload;
import com.elitesland.tw.tw5.api.prd.ts.query.TsNotaskApprovalConfigQuery;
import com.elitesland.tw.tw5.api.prd.ts.vo.TsNotaskApprovalConfigRuleVO;
import com.elitesland.tw.tw5.api.prd.ts.vo.TsNotaskApprovalConfigVO;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;

/**
 * notask_config
 *
 * @author zoey
 * @date 2024-04-30
 */
public interface TsNotaskApprovalConfigService {

    /**
     * 插入校验
     * @param payload
     * @return
     */
    Integer insertCheck(TsNotaskApprovalConfigPayload payload);

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link TsNotaskApprovalConfigVO}>
     */
    PagingVO<TsNotaskApprovalConfigVO> queryPaging(TsNotaskApprovalConfigQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link TsNotaskApprovalConfigVO}>
     */
    List<TsNotaskApprovalConfigVO> queryListDynamic(TsNotaskApprovalConfigQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link TsNotaskApprovalConfigVO}
     */
    TsNotaskApprovalConfigVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link TsNotaskApprovalConfigVO}
     */
    TsNotaskApprovalConfigVO insert(TsNotaskApprovalConfigPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link TsNotaskApprovalConfigVO}
     */
    TsNotaskApprovalConfigVO update(TsNotaskApprovalConfigPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(TsNotaskApprovalConfigPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);


    /**
     * 无任务活动列表
     * @param workDate
     * @return
     */
    List<PrdSystemSelectionVO> noTaskActivityList(LocalDate workDate);

    /**
     * 无任务配置规则查询
     * @param workDate
     * @param activity
     * @return
     */
    Map<String,Object> noTaskApprovalConfigRule(BigDecimal workHour,LocalDate workDate, String activity);

}
