package com.elitesland.tw.tw5.api.prd.work.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;
import java.util.List;

@Data
public class PrdWorkAssignmentQuery extends TwQueryParam {
    /**
     * 指派编号
     */
    @ApiModelProperty("指派编号")
    private String assignmentNo;

    /**
     * 名称
     */
    @ApiModelProperty("名称")
    private String assignmentName;

    /**
     * 优先级
     */
    @ApiModelProperty("优先级")
    private String priority;

    /**
     * 指派人
     */
    @ApiModelProperty("指派人")
    private Long assignUserId;

    /**
     * 协助人
     */
    @ApiModelProperty("协助人")
    private String assistUserIds;

    /**
     * 类型
     */
    @ApiModelProperty("类型")
    private String assignmentType;

    /**
     * 开始日期
     */
    @ApiModelProperty("开始日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate startDate;

    /**
     * 完成日期
     */
    @ApiModelProperty("结束日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate endDate;

    /**
     * 状态
     */
    @ApiModelProperty("状态")
    private String assignmentStatus;

    /**
     * 状态
     */
    @ApiModelProperty("状态")
    private List<String> assignmentStatusList;

    /**
     * 实际开始日期
     */
    @ApiModelProperty("实际开始日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate actualStartDate;

    /**
     * 实际完成日期
     */
    @ApiModelProperty("实际完成日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate actualFinishDate;

    /**
     * 任务id
     */
    @ApiModelProperty("任务id")
    private Long taskId;

    /**
     * 完成人
     */
    @ApiModelProperty("完成人")
    private Long finishUserId;

    /**
     * 进度
     */
    @ApiModelProperty("进度")
    private Integer progress;

    /**
     * 任务描述
     */
    @ApiModelProperty("任务描述")
    private String assignmentDesc;

    /**
     * 附件
     */
    @ApiModelProperty("附件")
    private String fileCodes;

    /**
     * 父id
     */
    @ApiModelProperty("父id")
    private Long parentId;

    /**
     * 参与用户id
     */
    @ApiModelProperty("参与用户id")
    private Long participantUserId;

    /**
     * 开始日期查询
     */
    @ApiModelProperty("开始日期查询")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate searchStartDate;

    /**
     * 结束日期查询
     */
    @ApiModelProperty("结束日期查询")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate searchEndDate;

    /**
     * 员工userId
     */
    @ApiModelProperty("员工userId")
    private Long empUserId;

    /**
     * 组织id
     */
    @ApiModelProperty("组织id")
    private Long orgId;
}
