package com.elitesland.tw.tw5.api.prd.acc.payload;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.prd.borrow.payload.BorrowMoneyPayload;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author sunxw
 * @description 报销单
 * @Date 2023/11/22
 */
@Data
@ApiModel("报销单")
public class AccReimPayload extends TwCommonPayload {

    @ApiModelProperty("报销单号")
    private String reimNo;

    @ApiModelProperty("报销人USER_ID")
    private Long reimUserId;

    @ApiModelProperty("报销人ORG_ID")
    private Long reimOrgId;

    @ApiModelProperty("报销人职级")
    private String reimResGrade;

    @ApiModelProperty("报销类型")
    private String reimType;

    @ApiModelProperty("单据类型")
    private String reimDocType;

    @ApiModelProperty("相关申请单")
    private Long relatedDocId;

    @ApiModelProperty("相关申请单名称")
    private String relatedDocName;

    @ApiModelProperty("相关预算")
    private Long relatedBudgetId;

    /**
     * 费用归属 【P_reim_.expense_classification】
     */
    @ApiModelProperty("费用归属")
    private String expenseClassification;

    @ApiModelProperty("费用承担项目")
    private Long expenseProjectId;

    @ApiModelProperty("费用承担部门")
    private Long expenseOrgId;

    @ApiModelProperty("费用承担公司")
    private Long expenseCompany;

    @ApiModelProperty("记账日期")
    private LocalDateTime accountingDate;

    @ApiModelProperty("报销单状态")
    private String reimStatus;

    @ApiModelProperty("报销说明")
    private String reimRemark;

    @ApiModelProperty("报销总额")
    private BigDecimal reimTotalAmt;

    @ApiModelProperty("调整后费用")
    private BigDecimal adjustAmt;

    @ApiModelProperty("借款核销金额")
    private BigDecimal  borrowWriteOffAmt;

    @ApiModelProperty("实际请款金额")
    private BigDecimal payAmt;

    @ApiModelProperty("付款日期")
    private LocalDateTime payDate;

    @ApiModelProperty("事由类型")
    private String reasonType;

    @ApiModelProperty("事由号")
    private Long reasonId;

    @ApiModelProperty("事由名称")
    private String reasonName;

    @ApiModelProperty("支付方式")
    private String payMethod;

    @ApiModelProperty("收款账户")
    private String accountNo;

    @ApiModelProperty("户名")
    private String holderName;

    @ApiModelProperty("收款银行")
    private String bankName;

    @ApiModelProperty("收款银行网点")
    private String bankBranch;

    @ApiModelProperty("付款方式：1.网银支付 2.手动支付")
    private String payMode;

    @ApiModelProperty("付款银行账号")
    private String payAccountNo;

    @ApiModelProperty("费用承担方")
    private String expenseByType;

    @ApiModelProperty("审批状态")
    private String apprStatus;

    @ApiModelProperty("流程实例id")
    private String procInstId;

    @ApiModelProperty("流程实例名称")
    private String procInstName;

    @ApiModelProperty("财务收单时间")
    private LocalDateTime finChargeUpTime;

    @ApiModelProperty("报销导出批次号，T_ACC_PAY_BATCH.BATCH_NO")
    private String batchNo;

    @ApiModelProperty("新批次号")
    private String batchNoLast;

    @ApiModelProperty("支付状态：S 成功、F 失败、C 撤销、D 过期、R 否决 G退票 Z支付中")
    private String payStatus;

    @ApiModelProperty("网银提交标识 1.已提交 2.未提交")
    private Integer bankFlag;

    @ApiModelProperty("网银提交时间")
    private LocalDateTime bankTime;

    @ApiModelProperty("附件")
    private String fileCode;

    @ApiModelProperty("申请日期")
    private LocalDate applyDate;

    @ApiModelProperty("财务负责人审批时间")
    private LocalDateTime finPicApprTime;

    @ApiModelProperty("流程节点名称")
    private String apprProcName;

    @ApiModelProperty("合同ID")
    private Long contractId;

    @ApiModelProperty("财务期间ID")
    private Long finPeriodId;

    @ApiModelProperty("财务稽核专员退回标记 0-未退回 1-退回")
    private Integer finRejectFlag;

    /**
     * 报销明细
     */
    private List<AccReimDetailPayload> details;

    /**
     * 被删除的明细id
     */
    private List<Long> deleteKeys;

    @ApiModelProperty("行政订票单ID集合")
    private List<Long> tripTicketIds;

    @ApiModelProperty("外包费用确认明细ID集合")
    private List<Long> epibolyCostDtlIds;

    @ApiModelProperty("提交标记")
    private Boolean submitFlag = false;

    /**
     * 更新标记 -> 方法判断走向使用
     */
    private Boolean updateFlag = false;

    @ApiModelProperty("高级修改标记")
    private Boolean advanceModifyFlag = false;

    @ApiModelProperty("主键集合")
    private List<Long> keys;

    @ApiModelProperty("类型")
    private String type;

    @ApiModelProperty("财务代收单的流程节点key")
    private String procTaskKey;

    @ApiModelProperty("是否异常")
    private Integer abnormalFlag;

    @ApiModelProperty("报销明细是否需要事由")
    private Integer reimDetailFlag;

    /** 扩展字段1 */
    @ApiModelProperty("扩展字段1")
    private String ext1;
    /** 扩展字段2 */
    @ApiModelProperty("扩展字段2")
    private String ext2;
    /** 扩展字段3 */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /** 扩展字段4 */
    @ApiModelProperty("扩展字段4")
    private String ext4;
    /** 扩展字段5 */
    @ApiModelProperty("扩展字段5")
    private String ext5;
    /** 扩展字段6 */
    @ApiModelProperty("扩展字段6")
    private String ext6;
    /** 借款列表 */
    @ApiModelProperty("借款列表")
    private List<BorrowMoneyPayload> borrowMoneyPayloadList;

    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;
}
