package com.elitesland.tw.tw5.api.prd.copartner.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 合伙人绩效自述配置
 *
 * @author carl
 * @date 2024-06-24
 */
@Getter
@Setter
public class PerformanceReadmeConfigQuery extends TwQueryParam implements Serializable {
    /**
     * 主键 精确
     */
    @ApiModelProperty("主键")
    private Long id;
    /**
     * 名称 模糊
     */
    @ApiModelProperty("名称")
    private String configName;
    /**
     * 考核周期 精确
     */
    @ApiModelProperty("考核周期")
    private String configCycle;
    /**
     * 开始日期 大于等于
     */
    @ApiModelProperty("开始日期")
    private LocalDate startDate;
    /**
     * 结束日期 小于等于
     */
    @ApiModelProperty("结束日期")
    private LocalDate endDate;
    /**
     * 状态 精确
     */
    @ApiModelProperty("状态")
    private String configStatus;
    /**
     * 发起人
     */
    @ApiModelProperty("发起人")
    private Long applyUserId;
    /**
     * 发起时间
     */
    @ApiModelProperty("发起时间")
    private LocalDateTime applyTime;
    /**
     * 完成时间
     */
    @ApiModelProperty("完成时间")
    private LocalDateTime finishTime;
}
