package com.elitesland.tw.tw5.api.prd.crm.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 商机成单率计算指标
 *
 * @author likunpeng
 * @date 2023-11-03
 */
@Getter
@Setter
public class CrmOpportunityMeasurePayload extends TwCommonPayload  implements Serializable {
    /** 商机数据源字段表ID */
    @ApiModelProperty("商机数据源字段表ID")
    private Long dataSourceFieldsId;
    /** 指标类型（23-11-04 未让前端传字段 有空处理） */
    @ApiModelProperty("指标类型")
    private String indicatorType;
    /** 商机表字段 */
    @ApiModelProperty("商机表字段")
    private String oppoTableFields;
    /** 商机表字段 */
    @ApiModelProperty("商机表字段")
    private String oppoTableFieldsName;
    /** 权重 */
    @ApiModelProperty("权重")
    private BigDecimal weights;
    /** 详情List */
    @ApiModelProperty("详情List")
    private List<CrmOpportunityMeasureDPayload> crmOpportunityMeasureDPayloads;
    /** 详情删除id */
    @ApiModelProperty("详情删除id")
    List<Long> measureDetailsDeleteKeys;

}
