package com.elitesland.tw.tw5.api.prd.crm.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @Author carl.wang
 * @Description 商机销售清单表
 * @Date
 **/

@Data

public class CrmOpportunitySalesPayload extends TwCommonPayload {
    /**
     * 商机ID
     */
    private Long oppoId;
    /**
     * 关联产品
     */
    private String relatedProduct;

    /**
     * 产品大类
     */
    private String bigType;
    /**
     * 产品小类
     */
    private String samllType;
    /**
     * 销售项含税
     */
    private BigDecimal saleTaxedAmt;
    /**
     * 销售税率
     */
    private BigDecimal saleTaxRate;
    /**
     * 销售项不含税
     */
    private BigDecimal saleNetAmt;
    /**
     * 采购项含税
     */
    private BigDecimal purTaxedAmt;
    /**
     * 销售项含税
     */
    private BigDecimal purTaxRate;
    /**
     * 采购项不含税
     */
    private BigDecimal purNetAmt;
    /**
     * 有效销售额
     */
    private BigDecimal effectiveAmt;
    /**
     * 供应商
     */
    private String supplier;

    /**
     * 4.0的id;
     */
    private Long salesIdV4;

    private Long oppoIdV4;

    private Long supplierIdV4;

}
