package com.elitesland.tw.tw5.api.prd.crm.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityMilestonePlanPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityMilestonePlanQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityMilestonePlanVO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 里程碑计划
 *
 * @author zoey
 * @date 2023-11-01
 */
public interface CrmOpportunityMilestonePlanService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link CrmOpportunityMilestonePlanVO}>
     */
    PagingVO<CrmOpportunityMilestonePlanVO> queryPaging(CrmOpportunityMilestonePlanQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link CrmOpportunityMilestonePlanVO}>
     */
    List<CrmOpportunityMilestonePlanVO> queryListDynamic(CrmOpportunityMilestonePlanQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link CrmOpportunityMilestonePlanVO}
     */
    CrmOpportunityMilestonePlanVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link CrmOpportunityMilestonePlanVO}
     */
    CrmOpportunityMilestonePlanVO insert(CrmOpportunityMilestonePlanPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link CrmOpportunityMilestonePlanVO}
     */
    CrmOpportunityMilestonePlanVO update(CrmOpportunityMilestonePlanPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(CrmOpportunityMilestonePlanPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 里程碑计划-发布计划
     *
     */
    void publish(Long id);
}
