package com.elitesland.tw.tw5.api.prd.humanresources.service;

import java.util.List;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdExamTempPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdExamTempQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdExamTempVO;


/**
 * @author : WWW
 * @date : 2023-11-13
 * @desc : 绩效考核模板Service
 */
 
public interface PrdExamTempService {
    
    /**
     * 新增绩效考核模板数据
     * @param prdExamTempPayload
     * @return
     */
    PrdExamTempVO save(PrdExamTempPayload prdExamTempPayload);
    
     /**
     * 根据主键更新
     * @param prdExamTempPayload
     * @return
     */
    PrdExamTempVO update(PrdExamTempPayload prdExamTempPayload);
    
    /**
     * 根据主键获取详情
     * @param id
     * @return
     */
    PrdExamTempVO get(Long id);
    
     /**
     * 分页查询列表
     * @param prdExamTempQuery
     * @return
     */
    PagingVO<PrdExamTempVO> page(PrdExamTempQuery prdExamTempQuery);
    
     /**
     * 根据主键批量删除
     * @param ids
     * @return
     */
    Long del(List<Long> ids);
    
    /**
      * 获取列表查询
      * @param prdExamTempQuery
      * @return
      */
     List<PrdExamTempVO> getList(PrdExamTempQuery prdExamTempQuery);
    
        /**
      * 根据条件修改
      * @param prdExamTempPayload
      * @return
      */
     Long updateByCondition(PrdExamTempPayload prdExamTempPayload);

    /**
     * 更新状态
     * @param prdExamTempPayload
     * @return
     */
    Long updateState(PrdExamTempPayload prdExamTempPayload);
}

