package com.elitesland.tw.tw5.api.prd.my.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;


/**
 * 资金划款
 *
 * @author wangluyu
 * @date 2024-02-27
 */
@Getter
@Setter
@ExcelIgnoreUnannotated
public class TMoneyTransferVO extends BaseViewModel implements Serializable {
    /**
     * 编号
     */
    @ApiModelProperty("编号")
    @ExcelProperty(index = 0,value = "资金划款编号")
    private String transferNo;
    /**
     * 申请人
     */
    @ApiModelProperty("申请人")
    private Long applicantUserId;

    /**
     * 申请人
     */
    @ApiModelProperty("申请人")
    @UdcName(udcName = "USER",codePropName = "applicantUserId")
    @ExcelProperty(index = 1,value = "申请人")
    private String applicantUserName;
    /**
     * 申请日期
     */
    @ApiModelProperty("申请日期")
    private LocalDate applicantTime;

    @ExcelProperty(index = 3,value = "申请日期")
    private String applicantTimeStr;

    public String getApplicantTimeStr(){
        if(applicantTime!=null){
            return applicantTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        return applicantTimeStr;
    }
    /**
     * 申请人所属bu
     */
    @ApiModelProperty("申请人所属bu")
    private Long applicantBuId;

    /**
     * 申请人所属bu
     */
    @ApiModelProperty("申请人所属bu")
    @UdcName(udcName = "BU",codePropName = "applicantBuId")
    @ExcelProperty(index = 2,value = "申请人部门")
    private String applicantBuName;
    /**
     * 划款公司
     */
    @ApiModelProperty("划款公司")
    private String transferCompany;
    /**
     * 划款公司bookid
     */
    @ApiModelProperty("划款公司bookid")
    private Long transferCompanyBookId;

    /**
     * 划款公司bookid
     */
    @ApiModelProperty("划款公司名称")
    @UdcName(udcName = "BOOK",codePropName = "transferCompanyBookId")
    @ExcelProperty(index = 4,value = "划款公司")
    private String transferCompanyName;
    /**
     * 划款账号
     */
    @ApiModelProperty("划款账号")
    private String transferAccount;

    /**
     * 划款账号
     */
    @ApiModelProperty("划款账号")
    @ExcelProperty(index = 5,value = "划款账号")
    private String transferAccountDesc;
    /**
     * 收款公司
     */
    @ApiModelProperty("收款公司")
    private String collectionCompany;
    /**
     * 收款公司bookid
     */
    @ApiModelProperty("收款公司bookid")
    private Long collectionCompanyBookId;

    /**
     * 收款公司
     */
    @ApiModelProperty("收款公司名称")
    @UdcName(udcName = "BOOK",codePropName = "collectionCompanyBookId")
    @ExcelProperty(index = 6,value = "收款公司")
    private String collectionCompanyName;
    /**
     * 收款账号
     */
    @ApiModelProperty("收款账号")
    private String collectionAccount;

    /**
     * 收款账号
     */
    @ApiModelProperty("收款账号")
    @ExcelProperty(index = 7,value = "收款账号")
    private String collectionAccountDesc;
    /**
     * 划款金额
     */
    @ApiModelProperty("划款金额")
    @ExcelProperty(index = 8,value = "划款金额")
    private BigDecimal transferMoney;
    /**
     * 支付方式 udc[ADMINISTRATION:COST:ACC_PAY_WAY]
     */
    @ApiModelProperty("支付方式 udc[ADMINISTRATION:COST:ACC_PAY_WAY]")
    private String payWay;

    /**
     * 支付方式
     */
    @ApiModelProperty("支付方式")
    @UdcName(udcName = "ADMINISTRATION:COST:ACC_PAY_WAY",codePropName = "payWay")
    @ExcelProperty(index = 9,value = "支付方式")
    private String payWayDesc;

    /**
     * 划款说明
     */
    @ApiModelProperty("划款说明")
    private String transferNote;
    /**
     * 划款状态
     */
    @ApiModelProperty("划款状态")
    private String transferStatus;

    /**
     * 划款状态 udc[ADMINISTRATION:COST:ACC_TRANSFER_STATUS]
     */
    @ApiModelProperty("划款状态 udc[ADMINISTRATION:COST:ACC_TRANSFER_STATUS]")
    @UdcName(udcName = "ADMINISTRATION:COST:ACC_TRANSFER_STATUS",codePropName = "transferStatus")
    private String transferStatusDesc;

    /**
     * 附件
     */
    @ApiModelProperty("附件")
    private String fileCodes;

    /**
     * 附件
     */
    @ApiModelProperty("附件")
    private Object fileDatas;
    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String apprStatus;
    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /**
     * 流程审批状态
     */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("流程审批状态")
    @ExcelProperty(index = 10,value = "状态")
    @UdcName(udcName = "appr_status",codePropName = "procInstStatus")
    private String procInstStatusDesc;
    /**
     * 提交时间
     */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;


    /**
     * 支付用途
     */
    @ApiModelProperty("支付用途")
    private String payPurpose;


    /**
     * 内部往来凭证（付方）
     */
    @ApiModelProperty("内部往来凭证（付方）")
    private String jdeDocNo;

    /**
     * 内部往来凭证2（收方）
     */
    @ApiModelProperty("内部往来凭证2（收方）")
    private String jdeDocNo2;


    /**
     * 内部往来凭证失败原因
     */
    @ApiModelProperty("内部往来凭证失败原因")
    private String jdeErrMsg;



    /**
     * 支付方式：1.网银支付 2.手动支付
     */
    @ApiModelProperty("支付方式：1.网银支付 2.手动支付")
    private Integer payMode;


    /**
     * 支付状态：S 成功、F 失败、C撤销、D 过期、R 否决 G退票
     */
    @ApiModelProperty("支付状态：S 成功、F 失败、C撤销、D 过期、R 否决 G退票")
    private String payStatus;
    @UdcName(udcName = "purchase:slip:pay_status",codePropName = "payStatus")
    private String payStatusDesc;



    /**
     * 支付时间
     */
    @ApiModelProperty("支付时间")
    private LocalDateTime payTime;


    /**
     * 网银提交标识 1.已提交 2.未提交
     */
    @ApiModelProperty("网银提交标识 1.已提交 2.未提交")
    private Integer bankFlag;


    /**
     * 网银失败原因
     */
    @ApiModelProperty("网银失败原因")
    private String bankErrmsg;

    /**
     * 网银提交时间
     */
    @ApiModelProperty("网银提交时间")
    private LocalDateTime bankTime;


    /**
     * 摘要
     */
    @ApiModelProperty("摘要")
    private String jdeSummary;

    /**
     * 凭证日期
     */
    @ApiModelProperty("凭证日期")
    private String jdeDocTime;



    /**
     * JDE凭证状态(成功、失败)
     */
    @ApiModelProperty("JDE凭证状态")
    private String jdeDocState;


}
