package com.elitesland.tw.tw5.api.prd.personplan.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PmsProjectRoleAssignmentPayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.PmsProjectRoleAssignmentQuery;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PmsProjectRoleAssignmentVO;

import java.util.List;

/**
 * 项目角色分配
 *
 * @author xxb
 * @date 2023-07-07
 */
public interface PmsProjectRoleAssignmentService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PmsProjectRoleAssignmentVO}>
     */
    PagingVO<PmsProjectRoleAssignmentVO> queryPaging(PmsProjectRoleAssignmentQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsProjectRoleAssignmentVO}>
     */
    List<PmsProjectRoleAssignmentVO> queryListDynamic(PmsProjectRoleAssignmentQuery query);


    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PmsProjectRoleAssignmentVO}
     */
    void insert(PmsProjectRoleAssignmentPayload payload);


    /**
     * 新增 相关方 角色设置
     * @param projectId
     * @param userId
     * @param projectRoleIds
     */
    void insert(Long projectId,Long userId,List<Long> projectRoleIds);

}
