package com.elitesland.tw.tw5.api.prd.pms.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 内部项目申请
 *
 * @author carl
 * @date 2023-08-23
 */
@Getter
@Setter
public class PmsInnerProjectApplyQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 项目名称 精确
     */
    @ApiModelProperty("项目名称")
    private String projName;
    /**
     * 工作类型 精确
     */
    @ApiModelProperty("工作类型")
    private String workType;
    /**
     * 项目模板 精确
     */
    @ApiModelProperty("项目模板")
    private Long projTempId;
    /**
     * 项目id 精确
     */
    @ApiModelProperty("项目id")
    private Long projId;
    /**
     * 签约公司 精确
     */
    @ApiModelProperty("签约公司")
    private Long ouId;
    /**
     * 币种 精确
     */
    @ApiModelProperty("币种")
    private String currCode;
    /**
     * 预计开始日期 精确
     */
    @ApiModelProperty("预计开始日期")
    private LocalDate startDate;
    /**
     * 预计结束日期 精确
     */
    @ApiModelProperty("预计结束日期")
    private LocalDate endDate;
    /**
     * 申请单号 精确
     */
    @ApiModelProperty("申请单号")
    private String applyNo;
    /**
     * 申请状态 精确
     */
    @ApiModelProperty("申请状态")
    private String apprStatus;
    /**
     * 申请人 精确
     */
    @ApiModelProperty("申请人")
    private Long applyResId;
    /**
     * 申请日期 精确
     */
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;
    /**
     * 费用承担bu 精确
     */
    @ApiModelProperty("费用承担bu")
    private Long expenseBuId;
    /**
     * 交付bu 精确
     */
    @ApiModelProperty("交付bu")
    private Long deliBuId;
    /**
     * 交付负责人 精确
     */
    @ApiModelProperty("交付负责人")
    private Long deliResId;
    /**
     * 销售负责人 精确
     */
    @ApiModelProperty("销售负责人")
    private Long salesmanResId;
    /**
     * 项目经理 精确
     */
    @ApiModelProperty("项目经理")
    private Long pmResId;
    /**
     * 预计总人天 精确
     */
    @ApiModelProperty("预计总人天")
    private BigDecimal totalDays;
    /**
     * 预计总当量 精确
     */
    @ApiModelProperty("预计总当量")
    private BigDecimal totalEqva;
    /**
     * 当量预估单价 精确
     */
    @ApiModelProperty("当量预估单价")
    private BigDecimal eqvaPrice;
    /**
     * 费用总预算 精确
     */
    @ApiModelProperty("费用总预算")
    private BigDecimal totalReimbursement;
    /**
     * 预算总成本 精确
     */
    @ApiModelProperty("预算总成本")
    private BigDecimal totalCost;
    /**
     * 删除标志 精确
     */
    @ApiModelProperty("删除标志")
    private Integer delFlag;
    /**
     * 关联项目Id
     */
    @ApiModelProperty("关联项目Id")
    private Long relatedProjId;
    /**
     * 关联项目编号 精确
     */
    @ApiModelProperty("关联项目编号")
    private String relatedProjNo;
    /**
     * 产品编号 精确
     */
    @ApiModelProperty("产品编号")
    private String productNo;
    /**
     * 研发补贴金额 精确
     */
    @ApiModelProperty("研发补贴金额")
    private BigDecimal subsidyAmt;
    /**
     * 折旧月数 精确
     */
    @ApiModelProperty("折旧月数")
    private Integer depreciationMonths;
    /**
     * 折旧开始时间 精确
     */
    @ApiModelProperty("折旧开始时间")
    private LocalDateTime depreciationStartDate;

    @ApiModelProperty("审批状态")
    private ProcInstStatus procInstStatus;

    /**
     * 需要权限
     */
    private Boolean permissionFlag = true;
}
