package com.elitesland.tw.tw5.api.prd.pms.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsRelyDataPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsRelyPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsRelyQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsRelyVO;


import java.util.List;

/**
 * 项目wbs前置依赖关系
 *
 * @author carl
 * @date 2023-07-19
 */
public interface PmsProjectWbsRelyService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PmsProjectWbsRelyVO}>
     */
    PagingVO<PmsProjectWbsRelyVO> queryPaging(PmsProjectWbsRelyQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsProjectWbsRelyVO}>
     */
    List<PmsProjectWbsRelyVO> queryListDynamic(PmsProjectWbsRelyQuery query);

    /**
     * 关联 wbs查询
     *
     * @param query 查询
     * @return {@link List}<{@link PmsProjectWbsRelyVO}>
     */
    List<PmsProjectWbsRelyVO> listLeftJoinWbs(PmsProjectWbsRelyQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PmsProjectWbsRelyVO}
     */
    PmsProjectWbsRelyVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PmsProjectWbsRelyVO}
     */
    void batchInsert(PmsProjectWbsRelyDataPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PmsProjectWbsRelyVO}
     */
    PmsProjectWbsRelyVO update(PmsProjectWbsRelyPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(PmsProjectWbsRelyPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 根据wbsId进行删除
     * @param aLong
     * @return
     */
    Boolean delByWbsId(Long aLong,Integer versionNo);
}
