package com.elitesland.tw.tw5.api.prd.pms.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsWbsActPayPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsWbsActPayQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsWbsActPayVO;


import java.util.List;

/**
 * wbs活动交付物
 *
 * @author carl
 * @date 2023-04-06
 */
public interface PmsWbsActPayService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PmsWbsActPayVO}>
     */
    PagingVO<PmsWbsActPayVO> paging(PmsWbsActPayQuery query);

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PmsWbsActPayVO}>
     */
    PagingVO<PmsWbsActPayVO> queryPaging(PmsWbsActPayQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsWbsActPayVO}>
     */
    List<PmsWbsActPayVO> queryList(PmsWbsActPayQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsWbsActPayVO}>
     */
    List<PmsWbsActPayVO> queryListDynamic(PmsWbsActPayQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PmsWbsActPayVO}
     */
    PmsWbsActPayVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PmsWbsActPayVO}
     */
    PmsWbsActPayVO insert(PmsWbsActPayPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PmsWbsActPayVO}
     */
    PmsWbsActPayVO update(PmsWbsActPayPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
