package com.elitesland.tw.tw5.api.prd.pms.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsWbsTemplateNodePayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsWbsTemplateNodeQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsWbsTemplateNodeVO;

import java.util.List;

/**
 * wbs模板节点
 *
 * @author Echo
 * @date 2023-03-29
 */
public interface PmsWbsTemplateNodeService {

    /**
     * 批量新增
     * @param nodePayloads
     */
    void batchInsert(List<PmsWbsTemplateNodePayload> nodePayloads, Long templateId);

    /**
     * 根据 模板 获取 节点集合
     * @param templateId
     * @return
     */
    List<PmsWbsTemplateNodeVO> queryByTemplateId(Long templateId);

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PmsWbsTemplateNodeVO}>
     */
    PagingVO<PmsWbsTemplateNodeVO> paging(PmsWbsTemplateNodeQuery query);

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PmsWbsTemplateNodeVO}>
     */
    PagingVO<PmsWbsTemplateNodeVO> queryPaging(PmsWbsTemplateNodeQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsWbsTemplateNodeVO}>
     */
    List<PmsWbsTemplateNodeVO> queryList(PmsWbsTemplateNodeQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsWbsTemplateNodeVO}>
     */
    List<PmsWbsTemplateNodeVO> queryListDynamic(PmsWbsTemplateNodeQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PmsWbsTemplateNodeVO}
     */
    PmsWbsTemplateNodeVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PmsWbsTemplateNodeVO}
     */
    PmsWbsTemplateNodeVO insert(PmsWbsTemplateNodePayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PmsWbsTemplateNodeVO}
     */
    PmsWbsTemplateNodeVO update(PmsWbsTemplateNodePayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
