package com.elitesland.tw.tw5.api.prd.pms.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsWbsVersionPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsWbsVersionQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsWbsVersionVO;

import java.util.List;


/**
 * pms版本表service
 *
 * @author wangxl
 * @date 2024/3/4
 */
public interface PmsWbsVersionService {

    /**
     * 分页查询
     *
     * @param query query
     * @return result
     */
    PagingVO<PmsWbsVersionVO> queryPage(PmsWbsVersionQuery query);

    /**
     * 列表查询
     *
     * @param query query
     * @return result
     */
    List<PmsWbsVersionVO> queryList(PmsWbsVersionQuery query);

    /**
     * count查询
     *
     * @param query query
     * @return result
     */
    long queryCount(PmsWbsVersionQuery query);

    /**
     * 根据主键获取详情
     *
     * @param id 主键
     * @return result
     */
    PmsWbsVersionVO queryByKey(Long id);

    /**
     * 新增
     *
     * @param payload payload
     * @return result
     */
    PmsWbsVersionVO insert(PmsWbsVersionPayload payload);

    /**
     * 修改
     *
     * @param payload payload
     * @return result
     */
    PmsWbsVersionVO update(PmsWbsVersionPayload payload);

    /**
     * 动态修改，一般只用在少部分字段修改的场景，比如修改状态
     *
     * @param payload payload
     * @return result
     */
    PmsWbsVersionVO updateDynamic(PmsWbsVersionPayload payload);

    /**
     * 逻辑删除
     *
     * @param ids ids
     * @return result
     */
    Long deleteSoft(List<Long> ids);

    /**
     * 获取版本号
     * 新建版本号在version表查询新建状态的一条记录 V1，查询新建状态的最新记录，若没有则查询激活状态，若没有则新建，返回一条版本号
     *
     * @param proId
     * @return
     */
    PmsWbsVersionVO getVersion(Long proId);

    /**
     * 根据状态获取该项目版本
     * @param proId
     * @param state
     * @return
     */
    PmsWbsVersionVO getVersionByState(Long proId, Integer state);
}