package com.elitesland.tw.tw5.api.prd.pms.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;

/**
 * 项目工作日历
 * @date 2023-06-21
 */
@Data
public class PmsProjectCalendarVO extends BaseViewModel implements Serializable {

    @ApiModelProperty("关联主键")
    private Long sourceId;

    @ApiModelProperty("关联类型：project、WBS")
    private String sourceType;

    @ApiModelProperty("开始时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate startDate;

    @ApiModelProperty("结束时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate endDate;

    @ApiModelProperty("日历详情")
    private List<Map<LocalDate, BigDecimal>> calendarList;

    @ApiModelProperty("是否设置固定班制 1设置 0不设置")
    private Integer setFixedShiftSystemFlag;

    @ApiModelProperty("休假日")
    private String holiday;

    @ApiModelProperty("预计持续天数")
    private Integer durationDays;

    @ApiModelProperty("休假天数")
    private Integer holiDays;

}
