package com.elitesland.tw.tw5.api.prd.pms.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;


/**
 * 项目wbs前置依赖关系
 *
 * @author carl
 * @date 2023-07-19
 */
@Getter
@Setter
public class PmsProjectWbsRelyVO extends BaseViewModel implements Serializable {
    /**
     * 项目主键
     */
    @ApiModelProperty("项目主键")
    private Long projectId;
    /**
     * wbs主键(依赖建立着，后置任务)
     */
    @ApiModelProperty("wbs主键(依赖建立着，后置任务)")
    private Long wbsId;
    /**
     * wbs状态 (连表查询)
     */
    private String wbsStatus;
    /**
     * wbs名称(依赖建立着，后置任务，冗余字段)
     */
    @ApiModelProperty("wbs名称(依赖建立着，后置任务，冗余字段)")
    private String wbsName;
    /**
     * wbs编码(依赖建立着，后置任务，冗余字段)
     */
    @ApiModelProperty("wbs编码(依赖建立着，后置任务，冗余字段)")
    private String nodeCode;
    /**
     * wbs主键(依赖前置任务)
     */
    @ApiModelProperty("wbs主键(依赖前置任务)")
    private Long wbsRelyId;
    /**
     * wbs名称(前置依赖名称，冗余字段）
     */
    @ApiModelProperty("wbs名称(前置依赖名称，冗余字段）")
    private String wbsRelyName;
    /**
     * wbs编码(依赖建立着，后置任务，冗余字段)
     */
    @ApiModelProperty("wbs编码(依赖建立着，后置任务，冗余字段)")
    private String nodeRelyCode;
    /**
     * wbs编码(依赖建立着，后置任务，冗余字段)
     */
    @ApiModelProperty("wbs编码(依赖建立着，后置任务，冗余字段)")
    private String wbsRelyCode;
    /**
     * 前置类型（FS）
     */
    @ApiModelProperty("前置类型（FS）")
    private String relyType;
    /**
     * 关系类型（活动ACT，里程碑：MS）
     */
    @ApiModelProperty("关系类型（活动ACT，里程碑：MS）")
    private String relationType;


    /**
     * 版本id
     */
    @ApiModelProperty("版本id")
    private Long versionId;

    /**
     * 版本号
     */
    @ApiModelProperty("版本号")
    private Integer versionNo;


    @ApiModelProperty("有效关联id")
    private Long effRelateId;


    /**
     * wbs编码
     */
    @ApiModelProperty("wbs编码")
    private String wbsCode;
}
