package com.elitesland.tw.tw5.api.prd.system.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 阶梯毛利率设置
 *
 * @author likunpeng
 * @date 2023-04-03
 */
@Getter
@Setter
public class PrdSystemGrossMarginPayload extends TwCommonPayload  implements Serializable {
    /** BU_ID */
    @ApiModelProperty("BU_ID")
    private Long buId;
    /** 年度 */
    @ApiModelProperty("年度")
    private Integer yearly;
    /** 合同金额 */
    @ApiModelProperty("合同金额")
    private BigDecimal amt;
    /** BU负责人ID */
    @ApiModelProperty("BU负责人ID")
    private Long buDirectorId;
    /** BU毛利率 */
    @ApiModelProperty("BU毛利率")
    private Integer buGrossMargin;
    /** 阶梯毛利率1 */
    @ApiModelProperty("阶梯毛利率1")
    private Integer ladderGrossMargin1;
    /** 阶梯负责人1ID */
    @ApiModelProperty("阶梯负责人1ID")
    private Long ladderDirectorId1;
    /** 阶梯毛利率2 */
    @ApiModelProperty("阶梯毛利率2")
    private Integer ladderGrossMargin2;
    /** 阶梯负责人2ID */
    @ApiModelProperty("阶梯负责人2ID")
    private Long ladderDirectorId2;
}
