package com.elitesland.tw.tw5.api.prd.system.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemBusinessObjectPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemBusinessObjectQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemBusinessObjectVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemMenuVO;

import java.util.List;
import java.util.Map;

/**
 * 业务对象
 *
 * @Author Bill
 * @Date 2023/9/15 11:28
 **/
public interface PrdSystemBusinessObjectService {

    /**
     * 业务对象新增
     * @param payload
     * @return
     */
    PrdSystemBusinessObjectVO insert(PrdSystemBusinessObjectPayload payload);


    /**
     * 业务对象修改
     * @param payload
     * @return
     */
    PrdSystemBusinessObjectVO update(PrdSystemBusinessObjectPayload payload);

    /**
     * 业务对象分页查询
     * @param query
     * @return
     */
    PagingVO<PrdSystemBusinessObjectVO> paging(PrdSystemBusinessObjectQuery query);

    /**
     * 业务对象删除
     * @param asList
     */
    void deleteSoft(List<Long> asList);


    /**
     * 主键查询
     * @param id
     * @return
     */
    PrdSystemBusinessObjectVO get(Long id);

    /**
     * 项目启动 自动创建业务对象
     * @param map key：业务编码 ，value：业务对象
     */
    void autoCreate(Map<String, PrdSystemBusinessObjectPayload> map);

    /**
     * 业务对象附带 功能列表
     * @return
     */
    List<PrdSystemBusinessObjectVO> listFunction();

    /**
     * 业务对象的 对应 角色下配置信息获取
     * @param query
     * @return
     */
    PrdSystemBusinessObjectVO listObjectConfig(PrdSystemBusinessObjectQuery query);

    /**
     * 功能对应的 角色下的配置信息 获取
     * @param query
     * @return
     */
    PrdSystemBusinessObjectVO listFunctionConfig(PrdSystemBusinessObjectQuery query);

    /**
     * 带拥有权限规则的功能
     * @param query
     * @return
     */
    List<PrdSystemBusinessObjectVO> listFunction(PrdSystemBusinessObjectQuery query);
}
