package com.elitesland.tw.tw5.api.prd.system.service;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemFinYearPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemFinYearQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFinYearVO;
import com.elitescloud.cloudt.common.base.PagingVO;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 财务年度
 *
 * @author likunpeng
 * @date 2023-04-12
 */
public interface PrdSystemFinYearService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PrdSystemFinYearVO}>
     */
    PagingVO<PrdSystemFinYearVO> queryPaging(PrdSystemFinYearQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PrdSystemFinYearVO}>
     */
    List<PrdSystemFinYearVO> queryListDynamic(PrdSystemFinYearQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PrdSystemFinYearVO}
     */
    PrdSystemFinYearVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PrdSystemFinYearVO}
     */
    PrdSystemFinYearVO insert(PrdSystemFinYearPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PrdSystemFinYearVO}
     */
    PrdSystemFinYearVO update(PrdSystemFinYearPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 查询有无此年度 没有就插入
     * @param finYear
     * @return
     */
    PrdSystemFinYearVO findByFinYear(Integer finYear);
}
