package com.elitesland.tw.tw5.api.prd.task.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.task.payload.PmsWbsTaskPayload;
import com.elitesland.tw.tw5.api.prd.task.query.PmsWbsTaskQuery;
import com.elitesland.tw.tw5.api.prd.task.vo.PmsWbsTaskVO;

import java.math.BigDecimal;
import java.util.List;

/**
 * 节点任务
 *
 * @author xxb
 * @date 2023-07-11
 */
public interface PmsWbsTaskService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PmsWbsTaskVO}>
     */
    PagingVO<PmsWbsTaskVO> queryPaging(PmsWbsTaskQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsWbsTaskVO}>
     */
    List<PmsWbsTaskVO> queryListDynamic(PmsWbsTaskQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PmsWbsTaskVO}
     */
    PmsWbsTaskVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PmsWbsTaskVO}
     */
    PmsWbsTaskVO insert(PmsWbsTaskPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PmsWbsTaskVO}
     */
    PmsWbsTaskVO update(PmsWbsTaskPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 根据节点删除任务
     *
     * @param wbsIds
     */
    void deleteSoftByWbsIds(List<Long> wbsIds);

    /**
     * 根据节点删除任务
     *
     * @param wbsIds
     */
    List<PmsWbsTaskVO> findByWbsIds(List<Long> wbsIds);

    /**
     * 指派任务
     *
     * @param keys
     * @param wbsId
     */
    void appointedTask(List<Long> keys, Long wbsId);

    /**
     * 任务 暂挂、激活、已完成
     *
     * @param keys
     * @param taskStatus
     */
    void updateTaskStatus(List<Long> keys, String taskStatus);

    /**
     * 编辑权重
     * @param key
     * @param weight
     */
    void updateTaskWeight(Long wbsId,Long key, BigDecimal weight);

}
