package com.elitesland.tw.tw5.api.prd.ab.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author zoey
 * @Description:通讯录
 * @date 2023/8/7 - 23:38
 */
@Data
public class PrdUserAbVO extends BaseViewModel {
    /**
     * 用户ID - T_RES.USER_ID
     */
    private Long userId;
    /**
     * 姓名
     */
    private String employeeName;
    /**
     * 工号
     */
    private String employeeNo;
    /**
     * 所属组织
     */
    private Long baseOrgId;

    @UdcName(udcName = "BU", codePropName = "baseOrgId")
    private String baseOrgName;

    /**
     * 主服务地
     */
    private String baseCity;

    @UdcName(udcName = "org:employee:serviceaddr", codePropName = "baseCity")
    private String baseCityName;

    /**
     *  手机 - T_AB_CONTACT.MOBILE
     */
    private String mobile;

    /**
     *  电邮 - T_AB_CONTACT.EMAIL
     */
    private String email;

    /**
     * 当量系数
     */
    private BigDecimal eqvaRatio;

    /**
     * 自然人ID - T_RES.PERSON_ID
     */
    private Long personId;

    /**
     * 姓名 - T_PERSON.PERSON_NAME
     */
    private String personName;

    /**
     * 性别 - T_PERSON.GENDER
     */
    private String gender;


//    /**
//     * 平台邮箱 - T_RES.EMAIL_ADDR
//     */
//    private String emailAddr;


    /**
     * 联系人类型 - T_AB_CONTACT.CONTACT_TYPE
     */
    private String contactType;

    /**
     * 排序
     */
    private Integer sortIndex;
}
