package com.elitesland.tw.tw5.api.prd.copartner.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.copartner.payload.PerformanceReadmeConfigUserPayload;
import com.elitesland.tw.tw5.api.prd.copartner.query.PerformanceReadmeConfigUserQuery;
import com.elitesland.tw.tw5.api.prd.copartner.vo.PerformanceReadmeConfigDetailVO;
import com.elitesland.tw.tw5.api.prd.copartner.vo.PerformanceReadmeConfigUserVO;

import java.util.List;

/**
 * 合伙人绩效自述员工表
 *
 * @author carl
 * @date 2024-06-24
 */
public interface PerformanceReadmeConfigUserService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PerformanceReadmeConfigUserVO}>
     */
    PagingVO<PerformanceReadmeConfigUserVO> queryPaging(PerformanceReadmeConfigUserQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PerformanceReadmeConfigUserVO}>
     */
    List<PerformanceReadmeConfigUserVO> queryListDynamic(PerformanceReadmeConfigUserQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PerformanceReadmeConfigUserVO}
     */
    PerformanceReadmeConfigUserVO queryByKey(Long key);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PerformanceReadmeConfigUserVO}
     */
    PerformanceReadmeConfigUserVO querySimpleByKey(Long key);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PerformanceReadmeConfigUserVO}
     */
    long updateByKeyDynamic(PerformanceReadmeConfigUserPayload payload);

    /**
     * 批量新增
     *
     * @param payloads 单据数据
     * @return {@link PerformanceReadmeConfigDetailVO}
     */
    List<PerformanceReadmeConfigUserVO> batchInsert(List<PerformanceReadmeConfigUserPayload> payloads);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    void procInstUpdate(PerformanceReadmeConfigUserPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 根据配置id逻辑删除
     *
     * @param configId 主键集合
     */
    void deleteSoftByConfigId(Long configId);
}
