package com.elitesland.tw.tw5.api.prd.crm.amap.query;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 附近客户筛选
 *
 * @author duwh
 * @date 2023-05-17
 */
@Getter
@Setter
public class AmapAroundQuery implements Serializable{


    /**
     * 必填 中心点坐标 规则： 经度和纬度用","分割，经度在前，纬度在后，经纬度小数点后不得超过6位
     */
    private String location;

    /**
     * 查询关键字 规则： 多个关键字用“|”分割
     */
    private String keywords;
    /**
     * 查询城市
     */
    private String city;
    /**
     * 排序规则 规定返回结果的排序规则。按距离排序：distance；综合排序：weight  默认 distance
     */
    private String sortrule;
    /**
     * 查询半径 取值范围:0-50000。规则：大于50000按默认值，单位：米 默认 5000
     */
    private Integer radius;
    /**
     * 查询POI类型  行业
     *
     * 默认 公司企业|知名企业|公司|广告装饰|建筑公司|医药公司|机械电子|冶金化工|网络科技|商业贸易|电信公司|矿产公司|工厂
     */
    private String types;

    /**
     * 每页记录数据 强烈建议不超过25，若超过25可能造成访问报错
     */
    private Integer offset;
    /**
     * 当前页数
     */
    private Integer page;

}
