package com.elitesland.tw.tw5.api.prd.humanresources.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;

@Data
public class PrdOrgResQuery extends TwQueryParam {

    @ApiModelProperty("资源编号")
    private String resNo;

    @ApiModelProperty("用户真实姓名")
    private String personName;

    @ApiModelProperty("员工编号")
    private String employeeNo;

    @ApiModelProperty("资源状态")
    private String resourceStatus;

    @ApiModelProperty("入职日期开始")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate enrollDateStart;
    
    @ApiModelProperty("入职日期截止")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate enrollDateEnd;

    @ApiModelProperty("默认组织id")
    private Long orgId;

    @ApiModelProperty("上级ID")
    private Long parentId;

    @ApiModelProperty("专业级别")
    private String extString1;

    @ApiModelProperty("管理级别")
    private String extString2;

    @ApiModelProperty("专业序列")
    private String extString3;

    @ApiModelProperty("职位序列")
    private String extString4;

    @ApiModelProperty("主服务地址")
    private String extString5;

    @ApiModelProperty("内部类型")
    private String extString6;

    @ApiModelProperty("资源类型二")
    private String extString9;

    @ApiModelProperty("合同到期日开始")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate extDate4Start;

    @ApiModelProperty("合同到期日截止")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate extDate4End;

    @ApiModelProperty("资源经理")
    private Long resManagerId;

    @ApiModelProperty("审批状态")
    private ProcInstStatus procInstStatus;

}
