package com.elitesland.tw.tw5.api.prd.my.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;

/**
* 双周计划
*
* @author duwh
* @date 2022-12-21
*/
@Data
public class TimesheetBiweeklyPayload extends TwCommonPayload  {
    /**
     * 生成周报日期 后台可以判断是哪个周, 不传值默认今天
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate generateDate;
    /** 提交人 */
    private Long tsUserId;
    /** 标题 后台会自动生成 */
    private String title;
    /** 双周计划类型 week 周报 后台会自动生成 */
    private String tsbType;
    /** 双周计划Buid 后台会自动生成 */
    private Long tsbBuId;
    /** 发送对象 多人已英文逗号开个 a,b,c */
    private String receiveUserIds;
    /** 是否已读 0 未读  1已读 后台会自动生成 */
    private Integer isRead;
    /** 本周开始日期 后台会自动生成 */
    private LocalDate startWeekDate;
    /** 本周结束日期 后台会自动生成 */
    private LocalDate endWeekDate;
    /** 所在年周 后台会自动生成 */
    private Integer yearWeek;
    /** 拓展1 */
    private String ext1;
    /** 拓展2 */
    private String ext2;
    /** 拓展3 */
    private String ext3;

}
