package com.elitesland.tw.tw5.api.prd.my.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

@Getter
@Setter
public class TAttendanceRuleQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 规则名称 精确
     */
    @ApiModelProperty("规则名称")
    private String ruleName;
    /**
     * 规则描述 精确
     */
    @ApiModelProperty("规则描述")
    private String ruleDesc;
    /**
     * 汇报对象 精确
     */
    @ApiModelProperty("汇报对象")
    private String reportToRes;
    /**
     * 规则类型 UDC（COM:ATTENDANCE_RULE_TYPE） 精确
     */
    @ApiModelProperty("规则类型 UDC（COM:ATTENDANCE_RULE_TYPE）")
    private String ruleType;
    /**
     * 规则状态，预留 精确
     */
    @ApiModelProperty("规则状态，预留")
    private String ruleStatus;
    /**
     * 超出范围外打卡方式，UDC（COM:ATTENDANCE_OUT_RANGE_RULE） 精确
     */
    @ApiModelProperty("超出范围外打卡方式，UDC（COM:ATTENDANCE_OUT_RANGE_RULE）")
    private String outRangeRuleWay;
    /**
     * 员工打卡时是否必须拍照，UDC（YESNO） 精确
     */
    @ApiModelProperty("员工打卡时是否必须拍照，UDC（YESNO）")
    private String needPhotoAttendance;
    /**
     * 员工异常打卡时可提交申请，审批通过后修正异常，每月最多补卡，UDC（COM:ATTENDANCE_PATCH_APPLY_LIMIT_COUNT） 精确
     */
    @ApiModelProperty("员工异常打卡时可提交申请，审批通过后修正异常，每月最多补卡，UDC（COM:ATTENDANCE_PATCH_APPLY_LIMIT_COUNT）")
    private Integer attendancePatchApplyLimitCount;
    /**
     * 规则生效时间，UDC（COM: ATTENDANCE_RULE_EFFECTIVE_TIME ） 精确
     */
    @ApiModelProperty("规则生效时间，UDC（COM: ATTENDANCE_RULE_EFFECTIVE_TIME ）")
    private String ruleEffectiveTime;
    /**
     * 强制打卡 精确
     */
    @ApiModelProperty("强制打卡")
    private String forceAttendance;
}

