package com.elitesland.tw.tw5.api.prd.my.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * 假期取消申请
 *
 * @author carl
 * @date 2024-06-18
 */
@Getter
@Setter
public class TUserVacationCancelQuery extends TwQueryParam implements Serializable {
    /**
     * 主键 精确
     */
    @ApiModelProperty("主键")
    private Long id;
    /**
     * 用户id 精确
     */
    @ApiModelProperty("用户id")
    private Long userId;
    /**
     * 直属领导id 精确
     */
    @ApiModelProperty("直属领导id")
    private Long pUserId;
    /**
     * 部门id 精确
     */
    @ApiModelProperty("部门id")
    private Long orgId;
    /**
     * 请假id 精确
     */
    @ApiModelProperty("请假id")
    private Long applyId;
    /**
     * 公司id 精确
     */
    @ApiModelProperty("公司id")
    private Long companyId;
    /**
     * 请假单号 模糊
     */
    @ApiModelProperty("请假单号")
    private String applyNo;
    /**
     * 操作类型 精确
     */
    @ApiModelProperty("操作类型")
    private String operType;
    /**
     * 修改说明
     */
    @ApiModelProperty("修改说明")
    private String cancelDesc;
    /**
     * 操作日期 精确
     */
    @ApiModelProperty("操作日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate cancelDate;
    /**
     * 审批状态 精确
     */
    @ApiModelProperty("审批状态")
    private String procInstStatus;
    /**
     * 流程id 精确
     */
    @ApiModelProperty("流程id")
    private String procInstId;
}
