package com.elitesland.tw.tw5.api.prd.my.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;


/**
 * 服务器申请
 *
 * @author lemon
 * @date 2023-09-23
 */
@Getter
@Setter
public class TServerApplyVO extends BaseViewModel implements Serializable {
    /** 申请人 */
    @ApiModelProperty("申请人")
    private Long applyResId;
    @UdcName(udcName = "USER", codePropName = "applyResId")
    private String applyResName;
    /** 申请时间 */
    @ApiModelProperty("申请时间")
    private LocalDate applyDate;
    /** 申请bu */
    @ApiModelProperty("申请bu")
    private Long applyBuId;
    @UdcName(udcName = "BU", codePropName = "applyBuId")
    private String applyBuName;
    /** 使用人 */
    @ApiModelProperty("使用人")
    private Long userResId;
    @UdcName(udcName = "USER", codePropName = "userResId")
    private String userResName;
    /** 使用bu */
    @ApiModelProperty("使用bu")
    private Long userBuId;
    @UdcName(udcName = "BU", codePropName = "userBuId")
    private String userBuName;
    /** 用途 */
    @ApiModelProperty("用途")
    private String purpose;
    /** 服务器类型 */
    @ApiModelProperty("服务器类型")
    private String type;
    @UdcName(udcName = "SERVER:SERVER_TYPE", codePropName = "type")
    private String typeDesc;
    /** 服务器品牌 */
    @ApiModelProperty("服务器品牌")
    private String brand;
    @UdcName(udcName = "SERVER:SERVER_BRAND", codePropName = "brand")
    private String brandDesc;
    /** 使用范围 */
    @ApiModelProperty("使用范围")
    private String useScope;
    @UdcName(udcName = "SERVER:SERVER_USE_SCOPE",codePropName = "useScope")
    private String userScopeDesc;
    /** 预计费用 */
    @ApiModelProperty("预计费用")
    private BigDecimal expectAmt;
    /** 费用承担bu */
    @ApiModelProperty("费用承担bu")
    private Long expenseBuId;
    @UdcName(udcName = "BU", codePropName = "expenseBuId")
    private String expenseBuName;
    /** CPU */
    @ApiModelProperty("CPU")
    private String cpu;
    @UdcName(udcName = "SERVER:SERVER_CPU", codePropName = "cpu")
    private String cpuDesc;
    /** 内存 */
    @ApiModelProperty("内存")
    private String memory;
    @UdcName(udcName = "SERVER:SERVER_MEMORY", codePropName = "memory")
    private String memoryDesc;
    /** 硬盘 */
    @ApiModelProperty("硬盘")
    private String hardDisk;
    /** 系统类型 */
    @ApiModelProperty("系统类型")
    private String sysType;
    /** 生效日期 */
    @ApiModelProperty("生效日期")
    private LocalDate effectiveDate;
    /** 使用日期开始 */
    @ApiModelProperty("使用日期开始")
    private LocalDate useDateStart;
    /** 使用日期结束 */
    @ApiModelProperty("使用日期结束")
    private LocalDate useDateEnd;
    /** 采购合同id */
    @ApiModelProperty("采购合同id")
    private Long purchaseConId;
    /** 申请编号 */
    @ApiModelProperty("申请编号")
    private String applyNo;
    /** 申请状态 */
    @ApiModelProperty("申请状态")
    private String applyStatus;
    /** 服务器名称 */
    @ApiModelProperty("服务器名称")
    private String serverName;
    /** 流程实例ID */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /** 流程审批状态 */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    @UdcName(udcName = "appr_status", codePropName = "procInstStatus")
    private String procInstStatusDesc;
    /** 提交时间 */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /** 审批时间 */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;
}

