package com.elitesland.tw.tw5.api.prd.partner.identity.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;


/**
 * 业务伙伴-合作伙伴
 *
 * @author wangly
 * @date 2023-05-16
 */
@Getter
@Setter
public class BusinessCollaboratePartnerInfoVO extends BaseViewModel implements Serializable {
    /**
     * 业务伙伴id business_partner.id
     */
    @ApiModelProperty("业务伙伴id")
    private Long partnerId;

    /**
     * 合作状态 udc[CRM:BUSINESS_PARTNER:STATUS]
     */
    @ApiModelProperty("合作状态 udc[CRM:BUSINESS_PARTNER:STATUS]")
    private String collaborateStatus;

    /**
     * 合作状态 udc[CRM:BUSINESS_PARTNER:STATUS]
     */
    @ApiModelProperty("合作状态 udc[CRM:BUSINESS_PARTNER:STATUS]")
    @UdcName(udcName = "CRM:BUSINESS_PARTNER:STATUS", codePropName = "collaborateStatus")
    private String collaborateStatusDesc;

    /**
     * 合作形式
     */
    @ApiModelProperty("合作形式")
    private String collaborateForm;

    /**
     * 合作等级 udc[crm:customer_grade]
     */
    @ApiModelProperty("合作等级 udc[crm:customer_grade]")
    private String collaborateGradle;

    /**
     * 合作等级 udc[crm:customer_grade]
     */
    @ApiModelProperty("合作等级 udc[crm:customer_grade]")
    @UdcName(udcName = "crm:customer_grade", codePropName = "collaborateGradle")
    private String collaborateGradleDesc;

    /**
     * 合作产品
     */
    @ApiModelProperty("合作产品")
    private String collaborateProduct;

    /**
     * 合作开始时间
     */
    @ApiModelProperty("合作开始时间")
    private LocalDate startTime;

    /**
     * 合作结束时间
     */
    @ApiModelProperty("合作结束时间")
    private LocalDate endTime;

    /**
     * 合作期间说明
     */
    @ApiModelProperty("合作期间说明")
    private String collaborateDescription;

    /**
     * 产品介绍附件
     */
    @ApiModelProperty("产品介绍附件")
    private String fileCodes1;

    /**
     * 产品介绍附件数据
     */
    @ApiModelProperty("产品介绍附件数据")
    private Object fileDatas1;

    /**
     * 合作协议附件
     */
    @ApiModelProperty("合作协议附件")
    private String fileCodes2;

    /**
     * 合作协议附件数据
     */
    @ApiModelProperty("合作协议附件数据")
    private Object fileDatas2;

    /**
     * 公司介绍附件 精确
     */
    @ApiModelProperty("公司介绍附件")
    private String fileCodes3;

    /**
     * 合作协议附件数据
     */
    @ApiModelProperty("合作协议附件数据")
    private Object fileDatas3;

    /**
     * 扩展字段1
     */
    @ApiModelProperty("扩展字段1")
    private String ext1;

    /**
     * 扩展字段2
     */
    @ApiModelProperty("扩展字段2")
    private String ext2;

    /**
     * 扩展字段3
     */
    @ApiModelProperty("扩展字段3")
    private String ext3;

    /**
     * 扩展字段4
     */
    @ApiModelProperty("扩展字段4")
    private String ext4;

    /**
     * 扩展字段5
     */
    @ApiModelProperty("扩展字段5")
    private String ext5;

    /**
     * 渠道负责人
     */
    @ApiModelProperty("渠道负责人")
    private Long channelUserId;

    /**
     * 渠道负责人名称
     */
    @ApiModelProperty("渠道负责人名称")
    @UdcName(udcName = "USER", codePropName = "channelUserId")
    private String channelUserName;

    /**
     * 合作类别 udc[CRM:BUSINESS_PARTNER:COLLABORATE_TYPE] 精确
     */
    @ApiModelProperty("合作类别 udc[CRM:BUSINESS_PARTNER:COLLABORATE_TYPE]")
    private String collaborateType;

    /**
     * 合作类别 udc[CRM:BUSINESS_PARTNER:COLLABORATE_TYPE] 精确
     */
    @ApiModelProperty("合作类别 udc[CRM:BUSINESS_PARTNER:COLLABORATE_TYPE]")
    @UdcName(udcName = "CRM:BUSINESS_PARTNER:COLLABORATE_TYPE", codePropName = "collaborateType")
    private String collaborateTypeDesc;

    /**
     * 伙伴服务行业 精确
     */
    @ApiModelProperty("伙伴服务行业")
    private String collaborateServiceIndustry;
    /**
     * 服务典型客户 精确
     */
    @ApiModelProperty("服务典型客户")
    private String collaborateCustomer;
    /**
     * 服务客户规模 精确
     */
    @ApiModelProperty("服务客户规模")
    private String serviceCustomerScale;

    /**
     * 合作区域 udc[crm:customer_region] 精确
     */
    @ApiModelProperty("合作区域 udc[crm:customer_region]")
    private String collaborateRegion;


    /**
     * 合作区域 udc[crm:customer_region] 精确
     */
    @ApiModelProperty("合作区域 udc[crm:customer_region]")
    @UdcName(udcName = "crm:customer_region", codePropName = "collaborateRegion")
    private String collaborateRegionDesc;


    /**
     * 对接人类型 udc[CRM:BUSINESS_PARTNER:CONTACT_TYPE] 精确
     */
    @ApiModelProperty("对接人类型 udc[CRM:BUSINESS_PARTNER:CONTACT_TYPE]")
    private String contactPeopleType;

    /**
     * 对接人类型 udc[CRM:BUSINESS_PARTNER:CONTACT_TYPE] 精确
     */
    @ApiModelProperty("对接人类型 udc[CRM:BUSINESS_PARTNER:CONTACT_TYPE]")
    @UdcName(udcName = "CRM:BUSINESS_PARTNER:CONTACT_TYPE", codePropName = "contactPeopleType")
    private String contactPeopleTypeDesc;

    /**
     * 我司负责人bu 精确
     */
    @ApiModelProperty("我司负责人bu")
    private Long buManageUserId;

    /**
     * 我司负责人bu 精确
     */
    @ApiModelProperty("我司负责人bu名称")
    @UdcName(udcName = "BU", codePropName = "buManageUserId")
    private String buManageUserName;

    /**
     * 我司负责人电话 精确
     */
    @ApiModelProperty("我司负责人电话")
    private String buManagePhone;
    /**
     * 我司负责人邮箱 精确
     */
    @ApiModelProperty("我司负责人邮箱")
    private String buManageEmail;
    /**
     * 合作伙伴标签
     */
    @ApiModelProperty("合作伙伴标签 udc[CRM:BUSINESS_PARTNER:COOP_TAG]")
    private String collaborateTag;

    /**
     * 合作伙伴标签
     */
    @ApiModelProperty("合作伙伴标签 udc[CRM:BUSINESS_PARTNER:COOP_TAG]")
    private String collaborateTagDesc;

    /**
     * 合作伙伴关键词 精确
     */
    @ApiModelProperty("合作伙伴关键词")
    private String collaborateKeyword;

    //流程字段
    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /**
     * 流程审批状态
     */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    /**
     * 提交时间
     */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

}
