package com.elitesland.tw.tw5.api.prd.partner.identity.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;


/**
 * 业务伙伴-经销商信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Getter
@Setter
public class BusinessDistributorInfoVO extends BaseViewModel implements Serializable {
    /**
     * 业务伙伴id business_partner.id
     */
    @ApiModelProperty("业务伙伴id")
    private Long partnerId;
    /**
     * 供应商编号
     */
    @ApiModelProperty("供应商编号")
    private String supplierNo;
    /**
     * 经销商状态 udc[CRM:BUSINESS_PARTNER:STATUS]
     */
    @ApiModelProperty("经销商状态 udc[CRM:BUSINESS_PARTNER:STATUS]")
    private String dealerStatus;

    /**
     * 经销商状态 udc[CRM:BUSINESS_PARTNER:STATUS]
     */
    @ApiModelProperty("经销商状态 udc[CRM:BUSINESS_PARTNER:STATUS]")
    @UdcName(udcName = "CRM:BUSINESS_PARTNER:STATUS", codePropName = "dealerStatus")
    private String dealerStatusDesc;

    /**
     * 经销商等级 udc[crm:customer_grade]
     */
    @ApiModelProperty("经销商等级 udc[crm:customer_grade]")
    private String dealerGradle;

    /**
     * 经销商等级 udc[crm:customer_grade]
     */
    @ApiModelProperty("经销商等级 udc[crm:customer_grade]")
    @UdcName(udcName = "crm:customer_grade", codePropName = "dealerGradle")
    private String dealerGradleDesc;

    /**
     * 授权产品
     */
    @ApiModelProperty("授权产品")
    private String authProduct;

    /**
     * 授权产品
     */
    @ApiModelProperty("授权产品")
    private String authProductDesc;

    /**
     * 销售区域
     */
    @ApiModelProperty("销售区域")
    private String salesArea;

    /**
     * 授权开始时间
     */
    @ApiModelProperty("授权开始时间")
    private LocalDate startTime;

    /**
     * 授权结束时间
     */
    @ApiModelProperty("授权结束时间")
    private LocalDate endTime;

    /**
     * 授权期间说明
     */
    @ApiModelProperty("授权期间说明")
    private String collaborateDescription;

    /**
     * 审核材料附件
     */
    @ApiModelProperty("审核材料附件")
    private String fileCodes1;

    /**
     * 审核材料附件数据
     */
    @ApiModelProperty("审核材料附件数据")
    private Object fileDatas1;

    /**
     * 实地考察附件
     */
    @ApiModelProperty("实地考察附件")
    private String fileCodes2;


    /**
     * 实地考察附件数据
     */
    @ApiModelProperty("实地考察附件数据")
    private Object fileDatas2;

    /**
     * 扩展字段1
     */
    @ApiModelProperty("扩展字段1")
    private String ext1;

    /**
     * 扩展字段2
     */
    @ApiModelProperty("扩展字段2")
    private String ext2;

    /**
     * 扩展字段3
     */
    @ApiModelProperty("扩展字段3")
    private String ext3;

    /**
     * 扩展字段4
     */
    @ApiModelProperty("扩展字段4")
    private String ext4;

    /**
     * 扩展字段5
     */
    @ApiModelProperty("扩展字段5")
    private String ext5;
}
