package com.elitesland.tw.tw5.api.prd.partner.identity.vo;

import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;


/**
  * 客户详情 页面配置解析表达式
  *
  * @author duwh
  * @date 2023-07-07
  */
@Getter
@Setter
public class BusinessPartnerCustomerVO implements Serializable {

    private String id;
    /** 地址簿id 用来和银行账户 基本信息 地址信息等关联 */
    @ApiModelProperty("地址簿id 用来和银行账户 基本信息 地址信息等关联")
    private String bookId;
    /** 业务伙伴编号 */
    @ApiModelProperty("业务伙伴编号")
    private String businessPartnerNo;
    /** 类型 udc[CRM:BUSINESS_PARTNER:TYPE] */
    @ApiModelProperty("类型 udc[CRM:BUSINESS_PARTNER:TYPE]")
    private String partnerType;
    /** 类型 udc[CRM:BUSINESS_PARTNER:TYPE] */
    @ApiModelProperty("类型描述 udc[CRM:BUSINESS_PARTNER:TYPE]")
    @UdcName(udcName = "CRM:BUSINESS_PARTNER:TYPE",codePropName = "partnerType")
    private String partnerTypeDesc;

    /** 业务伙伴名称 */
    @ApiModelProperty("业务伙伴名称")
    private String partnerName;
    /** 业务伙伴身份 udc[CRM:BUSINESS_PARTNER:IDENTITY] */
    @ApiModelProperty("业务伙伴身份 udc[CRM:BUSINESS_PARTNER:IDENTITY]")
    private String partnerIdentity;
    /** 业务伙伴身份 udc[CRM:BUSINESS_PARTNER:IDENTITY] */
    @ApiModelProperty("业务伙伴身份描述 udc[CRM:BUSINESS_PARTNER:IDENTITY]")
    private String partnerIdentityDesc;
    /** 行业 udc[crm:leads_customer_industry] */
    @ApiModelProperty("行业 udc[crm:leads_customer_industry]")
    private String partnerIndustry;
    /** 行业 udc[crm:leads_customer_industry] */

    @ApiModelProperty("行业描述 udc[crm:leads_customer_industry]")
    @UdcName(udcName = "crm:leads_customer_industry",codePropName = "partnerIndustry")
    private String partnerIndustryDesc;

    /** 性质 udc[crm:company_nature] */
    @ApiModelProperty("性质 udc[crm:company_nature]")
    private String partnerNature;

    /** 性质 udc[crm:company_nature] */
    @ApiModelProperty("性质描述 udc[crm:company_nature]")
    @UdcName(udcName = "crm:company_nature",codePropName = "partnerNature")
    private String partnerNatureDesc;

    /** 组织规模 udc[crm:customer_scale] */
    @ApiModelProperty("组织规模 udc[crm:customer_scale]")
    private String organizationScale;

    /** 组织规模 udc[crm:customer_scale] */
    @ApiModelProperty("组织规模描述 udc[crm:customer_scale]")
    @UdcName(udcName = "crm:customer_scale",codePropName = "organizationScale")
    private String organizationScaleDesc;
    /** 网址 */
    @ApiModelProperty("网址")
    private String partnerWebsite;
    /** 邮箱 */
    @ApiModelProperty("邮箱")
    private String partnerEmail;
    /** 传真 */
    @ApiModelProperty("传真")
    private String partnerFax;
    /** 电话 */
    @ApiModelProperty("电话")
    private String partnerPhone;
    /** 主交易货币  udc[SYSTEM_BASIC:CURRENCY] */
    @ApiModelProperty("主交易货币  udc[SYSTEM_BASIC:CURRENCY]")
    private String currency;

    /** 主交易货币  udc[SYSTEM_BASIC:CURRENCY] */
    @ApiModelProperty("主交易货币  udc[SYSTEM_BASIC:CURRENCY]")
    @UdcName(udcName = "SYSTEM_BASIC:CURRENCY",codePropName = "currency")
    private String currencyDesc;
    /** 主要语言 */
    @ApiModelProperty("主要语言")
    private String language;
    /** 主要语言 */
    @ApiModelProperty("主要语言")
    @UdcName(udcName = "SYSTEM_BASIC:LANGUAGE",codePropName = "language")
    private String languageDesc;
    /** 性别 udc[org:employee:sex] */
    @ApiModelProperty("性别 udc[org:employee:sex]")
    private String partnerSex;
    /** 性别 udc[org:employee:sex] */
    @ApiModelProperty("性别 udc[org:employee:sex]")
    @UdcName(udcName = "org:employee:sex",codePropName = "partnerSex")
    private String partnerSexDesc;
    /** 生日 */
    @ApiModelProperty("生日")
    private String partnerBirthday;
    /** 手机 */
    @ApiModelProperty("手机")
    private String partnerTelephone;
    /** 微信 */
    @ApiModelProperty("微信")
    private String partnerWeChat;
    /** 业务伙伴区域 */
    @ApiModelProperty("业务伙伴区域 udc[crm:customer_region]")
    private String partnerRegion;

    /** 业务伙伴区域 */
    @ApiModelProperty("业务伙伴区域 udc[crm:customer_region]")
    @UdcName(udcName="crm:customer_region",codePropName = "partnerRegion")
    private String partnerRegionDesc;
    /** 附件 */
    @ApiModelProperty("附件")
    private String fileCodes;
    /** 排序号 */
    @ApiModelProperty("排序号")
    private Integer sortNo;
    /** 拓展字段1 */
    @ApiModelProperty("拓展字段1")
    private String ext1;
    /** 拓展字段2 */
    @ApiModelProperty("拓展字段2")
    private String ext2;
    /** 拓展字段3 */
    @ApiModelProperty("拓展字段3")
    private String ext3;
    /** 拓展字段4 */
    @ApiModelProperty("拓展字段4")
    private String ext4;
    /** 拓展字段5 */
    @ApiModelProperty("拓展字段5")
    private String ext5;
    /** 母公司ID */
    @ApiModelProperty("母公司ID")
    private Long parentId;
    /** 母公司名称 */
    @ApiModelProperty("母公司名称")
    private String parentIdDesc;
    /** 国家 */
    @ApiModelProperty("国家")
    private String country;
    /** 省 */
    @ApiModelProperty("省")
    private String province;
    /** 市 */
    @ApiModelProperty("市")
    private String city;
    /** 区 */
    @ApiModelProperty("区")
    private String district;
    /** 详细地址 */
    @ApiModelProperty("详细地址")
    private String detailAddress;
    /** 省 */
    @ApiModelProperty("省")
    private String provinceName;
    /** 市 */
    @ApiModelProperty("市")
    private String cityName;
    /** 区 */
    @ApiModelProperty("区")
    private String districtName;

    @ApiModelProperty("省市区")
    private String address;

    /** 销售负责人Id */
    @ApiModelProperty("销售负责人Id")
    private String saleDutyId;

    /** 销售负责人名字 */
    @ApiModelProperty("销售负责人名字")
    private String saleDutyIdDesc;

    /** 客户id */
    @ApiModelProperty("客户id")
    private Long formalCustomerId;

    /**
     * 客户信息
     */
    private BusinessCustomerInfoVO customerInfo;
}
