package com.elitesland.tw.tw5.api.prd.partner.strategy.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 分级策略模型配置
 *
 * @author wangly
 * @date 2023-06-19
 */
@Getter
@Setter
public class BusinessStrategyModelPayload extends TwCommonPayload  implements Serializable {
    /** 模型编号 */
    @ApiModelProperty("模型编号")
    private String modelNo;
    /** 模型名称 */
    @ApiModelProperty("模型名称")
    private String modelName;
    /** 模型类型 udc[CRM:BUSINESS_STRATEGY_MODEL:TYPE] */
    @ApiModelProperty("模型类型 udc[CRM:BUSINESS_STRATEGY_MODEL:TYPE]")
    private String modelType;
    /** 是否标准模版 udc[CRM:BUSINESS_STRATEGY_MODEL:FLAG] */
    @ApiModelProperty("是否标准模版 udc[CRM:BUSINESS_STRATEGY_MODEL:FLAG]")
    private Boolean standaryFlag;
    /** 开始时间 */
    @ApiModelProperty("开始时间")
    private LocalDateTime startTime;
    /** 结束时间 */
    @ApiModelProperty("结束时间")
    private LocalDateTime endTime;
    /** 数据来源 udc[CRM:BUSINESS_STRATEGY_MODEL:SOURCE] */
    @ApiModelProperty("数据来源 udc[CRM:BUSINESS_STRATEGY_MODEL:SOURCE]")
    private String source;
    /** 时间范围 udc[CRM:BUSINESS_STRATEGY_MODEL:DATE] */
    @ApiModelProperty("时间范围 udc[CRM:BUSINESS_STRATEGY_MODEL:DATE]")
    private String dateRange;

    /** R权重 */
    @ApiModelProperty("R权重")
    private BigDecimal RWeight;

    /** F权重 */
    @ApiModelProperty("F权重")
    private BigDecimal FWeight;

    /** M权重 */
    @ApiModelProperty("M权重")
    private BigDecimal MWeight;

    /** 排序号 */
    @ApiModelProperty("排序号")
    private Integer sortNo;
    /** 拓展字段1 */
    @ApiModelProperty("拓展字段1")
    private String ext1;
    /** 拓展字段2 */
    @ApiModelProperty("拓展字段2")
    private String ext2;
    /** 拓展字段3 */
    @ApiModelProperty("拓展字段3")
    private String ext3;
    /** 拓展字段4 */
    @ApiModelProperty("拓展字段4")
    private String ext4;
    /** 拓展字段5 */
    @ApiModelProperty("拓展字段5")
    private String ext5;

    /** 模型指标集合 */
    @ApiModelProperty("模型指标集合")
    private List<BusinessModelIndexPayload> businessModelIndexPayloadList;


}
