package com.elitesland.tw.tw5.api.prd.personplan.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 项目角色
 *
 * @author xxb
 * @date 2023-07-07
 */
@Getter
@Setter
public class PmsProjectRoleQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 角色名称 模糊 */
    @ApiModelProperty("角色名称")
    private String roleName;
    /** 角色编号 模糊 */
    @ApiModelProperty("角色编号")
    private String roleCode;
    /** 平均单价 精确 */
    @ApiModelProperty("平均单价")
    private BigDecimal unitPrice;

    @ApiModelProperty("编号或名称")
    private String keyWord;

    @ApiModelProperty("主键集合")
    private List<Long> ids;
}
