package com.elitesland.tw.tw5.api.prd.pms.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;

/**
 * 项目工作日历
 *
 * @date 2023-06-21
 */
@Data
public class PmsProjectCalendarPayload extends TwCommonPayload implements Serializable {

    @ApiModelProperty("关联主键")
    private Long sourceId;

    @ApiModelProperty("关联类型：project、WBS")
    private String sourceType;

    @ApiModelProperty("开始时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate startDate;

    @ApiModelProperty("结束时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate endDate;

    @ApiModelProperty("日历详情")
    private List<Map<String, Object>> calendarList;

    @ApiModelProperty("是否设置固定班制 1设置 0不设置")
    private Integer setFixedShiftSystemFlag = 0;

    @ApiModelProperty("休假日")
    private String holiday;

    @ApiModelProperty("关联主键")
    private List<Long> sourceIds;

    @ApiModelProperty("持续工作天数")
    private Integer durationDays;

    @ApiModelProperty("从缓存读数据的标志")
    private Boolean fromCacheFlag = false;

    @ApiModelProperty("项目id")
    private Long projectId;
}
