package com.elitesland.tw.tw5.api.prd.pms.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * @author : WWW
 * @date : 2024-2-26
 * @desc : 项目wbs验收标准
 */
@Data
@ApiModel(description = "项目wbs验收标准")
public class PmsProjectWbsAcceptPayload extends TwCommonPayload {


    /**
     * wbs主键
     */
    @ApiModelProperty("wbs主键")
    private Long wbsId;

    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private Long projectId;

    /**
     * 验收项类型0交付项1自定义
     */
    @ApiModelProperty("验收项类型0交付项1自定义")
    private Integer type;

    /**
     * 验收内容
     */
    @ApiModelProperty("验收内容")
    private String content;


    /**
     * 负责人id
     */
    @ApiModelProperty("负责人id")
    private Long managerUserId;

    /**
     * 负责人名称
     */
    @ApiModelProperty("负责人名称")
    private String managerUserName;

    /**
     * 提醒计划前n天
     */
    @ApiModelProperty("提醒计划前n天")
    private String remindDay;

    /**
     * 提醒途径0企微1站内2邮箱
     */
    @ApiModelProperty("提醒途径0企微1站内2邮箱")
    private Integer remindChannel;

    /**
     * 版本id
     */
    @ApiModelProperty("版本id")
    private Long versionId;

    /**
     * 版本号
     */
    @ApiModelProperty("版本号")
    private Integer versionNo;


    @ApiModelProperty("有效关联id")
    private Long effRelateId;


    /**
     * wbs编码
     */
    @ApiModelProperty("wbs编码")
    private String wbsCode;

    @ApiModelProperty("完成情况")
    private String completeContent;

    @ApiModelProperty("验收结果 0未通过 1已通过")
    private Integer acceptanceStatus;

    @ApiModelProperty("验收说明")
    private String acceptanceInstructions;
}

