package com.elitesland.tw.tw5.api.prd.pms.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 预算科目明细
 *
 * @author Echo
 * @date 2023-04-24
 */
@Getter
@Setter
public class PmsBudgetTemplateSubjectQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 模板主键 精确 */
    @ApiModelProperty("模板主键")
    private Long templateId;
    /** 预算科目编号 精确 */
    /** 科目id */
    @ApiModelProperty("科目id")
    private Long subjectId;

    /** 上一级科目即父主键 */
    @ApiModelProperty("上一级科目即父主键")
    private Long parentId;

    /**
     * 层级
     */
    @ApiModelProperty("层级")
    private Integer subjectLevel;

    /**
     * 科目状态
     */
    @ApiModelProperty("科目状态 0正常  1弃用")
    private Integer subjectStatus;
}
