package com.elitesland.tw.tw5.api.prd.pms.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;


/**
 * @author : WWW
 * @date : 2024-2-26
 * @desc : 项目wbs资源分配
 */
@Data
@ApiModel(description = "项目wbs资源分配")
public class PmsProjectWbsResourceQuery extends TwQueryParam {


    /**
     * wbs主键
     */
    @ApiModelProperty("wbs主键")
    private Long wbsId;

    @ApiModelProperty("wbs主键集合")
    private List<Long> wbsIdList;

    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private Long projectId;

    /**
     * 相关方id
     */
    @ApiModelProperty("相关方id")
    private Long relatePartiesId;

    /**
     * 角色id
     */
    @ApiModelProperty("角色id")
    private Long roleId;

    /**
     * 负责人标识
     */
    @ApiModelProperty("负责人标识")
    private Boolean managerUserFlag;

    /**
     * 投入精力
     */
    @ApiModelProperty("投入精力")
    private BigDecimal input;


    /**
     * 版本id
     */
    @ApiModelProperty("版本id")
    private Long versionId;

    /**
     * 版本号
     */
    @ApiModelProperty("版本号")
    private Integer versionNo;


    @ApiModelProperty("有效关联id")
    private Long effRelateId;
}

