package com.elitesland.tw.tw5.api.prd.pms.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsListVO;

import java.util.List;

/**
 * wbs 活动清单
 *
 * @author duwh
 * @date 2024/03/05
 */
public interface PmsProjectActListService {

    /**
     * 分页查询
     *
     * @param query 查询
     * @return {@link PagingVO}<{@link PmsProjectWbsListVO}>
     */
    PagingVO<PmsProjectWbsListVO> queryPage(PmsProjectWbsQuery query);

    /**
     * 更新wbs状态
     *
     * @param id        主键
     * @param wbsStatus wbs状态
     * @return {@link Long}
     */
    Long updateWbsStatus(Long id, String wbsStatus);

    /**
     * 更新预算释放状态
     *
     * @param idList id列表
     * @return {@link Long}
     */
    Long updateReleaseFlag(List<Long> idList);

    Long updateReleaseFlagByEffRelateId(List<Long> effRelateIdList);

    List<PmsProjectWbsListVO> queryList(PmsProjectWbsQuery pmsProjectWbsQuery);

    Long updateWbsStatusByVersionIdAndEffRelateId(Long versionId, Long effRelateId, String wbsStatus);
}
